/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block_entities;

import chiefarug.mods.systeams.SysteamsConfig;
import chiefarug.mods.systeams.SysteamsRegistry;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.util.managers.IFuelManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public abstract class BoilerBlockEntityBase
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable,
IThermalInventory {
    private static final int TRANSFER_PER_TICK = 1000;
    private final Predicate<FluidStack> isWater = fluid -> this.filter.valid(fluid) && SysteamsRegistry.Fluids.WATER_TAG.contains((Object)fluid.getFluid());
    public final FluidStorageCoFH waterTank = new FluidStorageCoFH(8000, this.isWater);
    private final Predicate<FluidStack> isSteam = fluid -> SysteamsRegistry.Fluids.STEAM_TAG.contains((Object)fluid.getFluid());
    public final FluidStorageCoFH steamTank = new FluidStorageCoFH(16000, this.isSteam);
    private LazyOptional<?> steamCap = LazyOptional.empty();
    private Direction facing;
    protected int fuelRemaining;
    protected int fuelMax = 0;
    protected int baseEnergyPerTick = this.getBaseProcessTick();
    protected int steamPerTick = this.calcSteam(this.baseEnergyPerTick);
    protected int waterPerTick = this.calcWater(this.steamPerTick);
    protected float generationModifier = 1.0f;
    protected float efficiencyModifier = 1.0f;

    public BoilerBlockEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.tankInv.addTank(this.waterTank, StorageGroup.INPUT);
        this.tankInv.addTank(this.steamTank, StorageGroup.OUTPUT);
        this.facing = (Direction)state.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.isActive = false;
                } else {
                    this.processStart();
                }
            }
        } else if (Utils.timeCheckQuarter() && this.redstoneControl.getState() && this.canProcessStart()) {
            this.processStart();
            this.processTick();
            this.isActive = true;
        }
        this.updateActiveState(curActive);
    }

    protected boolean canProcessStart() {
        return (this.getFuelEnergy() > 0 || this.fuelRemaining > 0) && this.waterTank.getAmount() >= this.waterPerTick && this.hasSteamSpace();
    }

    private boolean hasSteamSpace() {
        return !this.steamTank.isFull() || this.simulateInsertToAdjacent((BlockEntity)this, this.steamTank, 1000, this.getFacing());
    }

    protected void processStart() {
        if (this.fuelRemaining <= 0) {
            int fuelToAdd = this.calcSteam((int)((float)this.consumeFuel() * this.efficiencyModifier));
            this.fuelRemaining += fuelToAdd;
            this.fuelMax = fuelToAdd;
        }
        this.transferSteamOut();
    }

    protected void processFinish() {
        this.transferSteamOut();
    }

    protected boolean canProcessFinish() {
        return this.fuelRemaining <= 0 || this.waterTank.getAmount() < this.waterPerTick || !this.hasSteamSpace();
    }

    protected void processTick() {
        this.transferSteamOut();
        this.generateSteam();
    }

    private void generateSteam() {
        this.fuelRemaining -= this.steamPerTick;
        this.steamTank.fill(new FluidStack(SysteamsRegistry.Fluids.STEAM.getStill(), this.steamPerTick), IFluidHandler.FluidAction.EXECUTE);
        this.waterTank.drain((int)((double)this.waterPerTick), IFluidHandler.FluidAction.EXECUTE);
    }

    protected abstract int consumeFuel();

    protected int getFuelEnergy() {
        IDynamoFuel fuel = this.getFuelManager().getFuel((IThermalInventory)this);
        return fuel == null ? 0 : fuel.getEnergy();
    }

    protected abstract double getEnergyToSteamRatio();

    protected abstract IFuelManager getFuelManager();

    protected abstract double getSpeedMultiplier();

    public int getScaledDuration(int scale) {
        if (this.fuelMax <= 0 || this.fuelRemaining <= 0) {
            return 0;
        }
        return (int)((double)scale * (double)this.fuelRemaining / (double)this.fuelMax);
    }

    protected int getBaseEnergyStorage() {
        return 0;
    }

    protected Predicate<ItemStack> augValidator() {
        BiPredicate validator = this.tankInv.hasTanks() ? ThermalAugmentRules.DYNAMO_VALIDATOR : ThermalAugmentRules.DYNAMO_NO_FLUID_VALIDATOR;
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && validator.test(item, this.getAugmentsAsList());
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.generationModifier = 1.0f;
        this.efficiencyModifier = 1.0f;
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"DynamoPower", (float)this.generationModifier);
        AugmentableHelper.setAttribute((CompoundTag)this.augmentNBT, (String)"DynamoEnergy", (float)this.efficiencyModifier);
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"DynamoPower");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)this.augmentNBT, (CompoundTag)augmentData, (String)"DynamoEnergy");
        this.generationModifier += AugmentableHelper.getAttributeModWithDefault((CompoundTag)augmentData, (String)"DynamoPower", (float)0.0f);
        this.efficiencyModifier *= AugmentableHelper.getAttributeModWithDefault((CompoundTag)augmentData, (String)"DynamoEnergy", (float)1.0f);
    }

    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.generationModifier = MathHelper.clamp((float)(this.generationModifier * AugmentableHelper.getAttributeModWithDefault((CompoundTag)this.augmentNBT, (String)"BaseMod", (float)1.0f)), (float)Constants.AUG_SCALE_MIN, (float)Constants.AUG_SCALE_MAX);
        this.efficiencyModifier = MathHelper.clamp((float)this.efficiencyModifier, (float)Constants.AUG_SCALE_MIN, (float)Constants.AUG_SCALE_MAX);
        this.baseEnergyPerTick = Math.round((float)this.getBaseProcessTick() * this.generationModifier);
        this.steamPerTick = this.calcSteam(this.baseEnergyPerTick);
        this.waterPerTick = this.calcWater(this.steamPerTick);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fuelMax = nbt.m_128451_("FuelMax");
        this.fuelRemaining = nbt.m_128451_("Fuel");
        this.steamPerTick = nbt.m_128451_("ProcTick");
        this.updateHandlers();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("FuelMax", this.fuelMax);
        nbt.m_128405_("Fuel", this.fuelRemaining);
        nbt.m_128405_("ProcTick", this.steamPerTick);
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.fuelMax);
        buffer.writeInt(this.fuelRemaining);
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.fuelMax = buffer.readInt();
        this.fuelRemaining = buffer.readInt();
    }

    public double getEfficiency() {
        if (this.getFuelEfficiencyMod() <= 0.0f) {
            return Double.MIN_VALUE;
        }
        return this.getFuelEfficiencyMod();
    }

    private float getFuelEfficiencyMod() {
        return this.efficiencyModifier;
    }

    public int getCurSpeed() {
        return this.isActive ? this.steamPerTick : 0;
    }

    public int getWaterConsumption() {
        return this.isActive ? this.waterPerTick : 0;
    }

    public List<? extends IItemStackHolder> inputSlots() {
        return this.inventory.getInputSlots();
    }

    public List<? extends IFluidStackHolder> inputTanks() {
        return this.tankInv.getInputTanks();
    }

    protected void transferSteamOut() {
        FluidHelper.insertIntoAdjacent((BlockEntity)this, (FluidStorageCoFH)this.steamTank, (int)1000, (Direction)this.getFacing());
    }

    private int calcSteam(int energy) {
        return (int)Math.round((double)energy * this.getEnergyToSteamRatio() * this.getSpeedMultiplier());
    }

    private int calcWater(int steam) {
        return (int)Math.round((double)steam / (Double)SysteamsConfig.WATER_TO_STEAM_RATIO.get());
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            this.updateFacing();
        }
        return this.facing;
    }

    protected void updateFacing() {
        this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL);
        this.updateHandlers();
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        return super.getItemHandlerCapability(side);
    }

    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            if (!this.steamCap.isPresent()) {
                this.steamCap = LazyOptional.of(() -> this.tankInv.getHandler(StorageGroup.OUTPUT));
            }
            return this.steamCap.cast();
        }
        return super.getFluidHandlerCapability(side);
    }

    private boolean simulateInsertToAdjacent(BlockEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        IFluidHandler.FluidAction action = IFluidHandler.FluidAction.SIMULATE;
        if (tank.isEmpty()) {
            return false;
        }
        amount = Math.min(amount, tank.getAmount());
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity((BlockEntity)tile, (Direction)side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap((BlockEntity)adjTile, (Direction)(opposite = side.m_122424_()));
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        int fillAmount = handler.fill(new FluidStack(tank.getFluidStack(), amount), action);
        if (fillAmount > 0) {
            tank.drain(fillAmount, action).getAmount();
            return true;
        }
        return false;
    }
}

