/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.gui;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class RevengeGui
extends GuiElement {
    private final KeyframeAnimation showAnimationLeft;
    private final KeyframeAnimation hideAnimationLeft;
    private final KeyframeAnimation showAnimationRight;
    private final KeyframeAnimation hideAnimationRight;
    private final GuiTexture indicatorLeft;

    public RevengeGui() {
        super(0, 14, 13, 3);
        this.setAttachment(GuiAttachment.middleCenter);
        this.indicatorLeft = new GuiTexture(-3, 0, 5, 3, 9, 4, GuiTextures.hud);
        this.addChild((GuiElement)this.indicatorLeft);
        GuiTexture indicatorRight = new GuiTexture(3, 0, 5, 3, 15, 4, GuiTextures.hud);
        indicatorRight.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)indicatorRight);
        this.showAnimationLeft = new KeyframeAnimation(120, (GuiElement)this.indicatorLeft).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.hideAnimationLeft = new KeyframeAnimation(60, (GuiElement)this.indicatorLeft).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-3.0f)});
        this.showAnimationRight = new KeyframeAnimation(120, (GuiElement)indicatorRight).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.hideAnimationRight = new KeyframeAnimation(60, (GuiElement)indicatorRight).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(3.0f)});
    }

    public void update(Player player, HitResult mouseover) {
        if (mouseover != null && mouseover.m_6662_() == HitResult.Type.ENTITY && RevengeTracker.canRevenge((LivingEntity)player) && RevengeTracker.canRevenge((Entity)player, ((EntityHitResult)mouseover).m_82443_())) {
            if (!this.showAnimationLeft.isActive() && this.indicatorLeft.getOpacity() < 1.0f) {
                this.showAnimationLeft.start();
                this.showAnimationRight.start();
            }
            this.hideAnimationLeft.stop();
            this.hideAnimationRight.stop();
        } else {
            if (!this.hideAnimationLeft.isActive() && this.indicatorLeft.getOpacity() > 0.0f) {
                this.hideAnimationLeft.start();
                this.hideAnimationRight.start();
            }
            this.showAnimationLeft.stop();
            this.showAnimationRight.stop();
        }
    }
}

