/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.fluid;

import cofh.lib.util.Constants;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.ITickableGridNode;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.grid.GridNode;
import cofh.thermal.dynamics.grid.fluid.FluidGrid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidGridNode
extends GridNode<FluidGrid>
implements ITickableGridNode {
    protected Direction[] distArray = new Direction[0];
    protected int distIndex = 0;

    protected FluidGridNode(FluidGrid grid) {
        super(grid);
    }

    protected void cacheConnections() {
        for (Direction dir : Constants.DIRECTIONS) {
            if (!((FluidGrid)this.grid).canConnectOnSide(this.pos.m_121945_(dir), dir.m_122424_())) continue;
            this.connections.add(dir);
        }
        this.distArray = this.connections.toArray(new Direction[0]);
        this.cached = true;
    }

    @Override
    public void attachmentTick() {
        IDuct<?, ?> duct = this.gridHost();
        if (duct == null) {
            return;
        }
        for (Direction dir : Constants.DIRECTIONS) {
            duct.getAttachment(dir).tick();
        }
    }

    @Override
    public void distributionTick() {
        IDuct<?, ?> duct;
        if (!this.cached) {
            this.cacheConnections();
        }
        if ((duct = this.gridHost()) != null && this.distArray.length > 0) {
            int i;
            ++this.distIndex;
            this.distIndex %= this.distArray.length;
            Level world = this.getWorld();
            for (i = this.distIndex; i < this.distArray.length; ++i) {
                this.tickDir(world, this.pos, duct, this.distArray[i]);
            }
            for (i = 0; i < this.distIndex; ++i) {
                this.tickDir(world, this.pos, duct, this.distArray[i]);
            }
        }
    }

    private void tickDir(Level world, BlockPos pos, IDuct<?, ?> duct, Direction dir) {
        if (duct.getConnectionType(dir) == IDuct.ConnectionType.DISABLED) {
            return;
        }
        IAttachment attachment = duct.getAttachment(dir);
        BlockEntity tile = world.m_7702_(pos.m_121945_(dir));
        if (tile == null) {
            return;
        }
        attachment.wrapExternalCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.m_122424_())).ifPresent(e -> ((FluidGrid)this.grid).drain(e.fill(((FluidGrid)this.grid).getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
    }
}

