/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.client;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.TheurgyConstants;
import com.klikli_dev.theurgy.client.render.BlankEntityRenderer;
import com.klikli_dev.theurgy.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.item.DivinationRodItem;
import com.klikli_dev.theurgy.registry.EntityRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.tooltips.TooltipHandler;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientSetupEventHandler {
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientSetupEventHandler.registerTooltipDataProviders(event);
        ClientSetupEventHandler.registerItemProperties(event);
        Theurgy.LOGGER.info("Client setup complete.");
    }

    public static void registerTooltipDataProviders(FMLClientSetupEvent event) {
        TooltipHandler.registerNamespaceToListenTo("theurgy");
        TooltipHandler.registerTooltipDataProvider((Item)ItemRegistry.ALCHEMICAL_SULFUR.get(), AlchemicalSulfurItem::getTooltipData);
    }

    public static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.FOLLOW_PROJECTILE.get(), BlankEntityRenderer::new);
    }

    public static void registerItemProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof DivinationRodItem).forEach(item -> {
                ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)TheurgyConstants.ItemProperty.DIVINATION_DISTANCE, (ItemPropertyFunction)DivinationRodItem.DistHelper.DIVINATION_DISTANCE);
                Theurgy.LOGGER.debug("Registered Divination Rod Properties for: {}", (Object)item.getKey());
            });
            Theurgy.LOGGER.debug("Finished registering Item Properties.");
        });
    }
}

