/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.armor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import twilightforest.client.model.armor.TFArmorModel;

public class YetiArmorModel
extends TFArmorModel {
    private final EquipmentSlot slot;
    private final ModelPart bipedLegBody;
    private final ModelPart rightRuff;
    private final ModelPart leftRuff;
    private final ModelPart rightToe;
    private final ModelPart leftToe;

    public YetiArmorModel(EquipmentSlot slot, ModelPart part) {
        super(part);
        this.slot = slot;
        this.bipedLegBody = part.m_171324_("biped_leg_body");
        this.rightRuff = this.f_102813_.m_171324_("right_ruff");
        this.leftRuff = this.f_102814_.m_171324_("left_ruff");
        this.rightToe = this.f_102813_.m_171324_("right_toe");
        this.leftToe = this.f_102814_.m_171324_("left_toe");
    }

    public static MeshDefinition addPieces(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -7.5f, -4.0f, 9.0f, 8.0f, 8.0f, deformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        YetiArmorModel.addPairHorns(head, 1, -8.0f, 35.0f);
        YetiArmorModel.addPairHorns(head, 2, -6.0f, 15.0f);
        YetiArmorModel.addPairHorns(head, 3, -4.0f, -5.0f);
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        rightLeg.m_171599_("right_ruff", CubeListBuilder.m_171558_().m_171514_(40, 22).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 2.0f, 5.0f, deformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        leftLeg.m_171599_("left_ruff", CubeListBuilder.m_171558_().m_171514_(40, 22).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 2.0f, 5.0f, deformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        rightLeg.m_171599_("right_toe", CubeListBuilder.m_171558_().m_171514_(40, 17).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 2.0f, 1.0f, deformation), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-2.0f));
        leftLeg.m_171599_("left_toe", CubeListBuilder.m_171558_().m_171514_(40, 17).m_171488_(-2.0f, 0.0f, -1.0f, 4.0f, 2.0f, 1.0f, deformation), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-2.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 11.0f, 4.0f, deformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("biped_leg_body", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, deformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return meshdefinition;
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.bipedLegBody));
    }

    private static void addPairHorns(PartDefinition partdefinition, int iter, float height, float zangle) {
        PartDefinition leftBottom = partdefinition.m_171599_("horn_" + iter + "_left_bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(-3.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)-4.5f, (float)height, (float)-1.0f, (float)0.0f, (float)-0.5235988f, (float)(zangle / 57.295776f)));
        leftBottom.m_171599_("horn_" + iter + "_left_top", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-4.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.34906587f, (float)(zangle / 57.295776f)));
        PartDefinition rightBottom = partdefinition.m_171599_("horn_" + iter + "_right_bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.m_171423_((float)4.5f, (float)height, (float)-1.0f, (float)0.0f, (float)0.5235988f, (float)(-zangle / 57.295776f)));
        rightBottom.m_171599_("horn_" + iter + "_right_top", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(-1.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.34906587f, (float)(-zangle / 57.295776f)));
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.bipedLegBody.f_104207_ = visible;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float scale) {
        switch (this.slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.f_102809_.f_104207_ = false;
                this.f_102810_.f_104207_ = false;
                this.f_102811_.f_104207_ = false;
                this.f_102812_.f_104207_ = false;
                this.bipedLegBody.f_104207_ = false;
                this.f_102813_.f_104207_ = false;
                this.f_102814_.f_104207_ = false;
                break;
            }
            case CHEST: {
                this.f_102808_.f_104207_ = false;
                this.f_102809_.f_104207_ = false;
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                this.bipedLegBody.f_104207_ = false;
                this.f_102813_.f_104207_ = false;
                this.f_102814_.f_104207_ = false;
                break;
            }
            case LEGS: {
                this.f_102808_.f_104207_ = false;
                this.f_102809_.f_104207_ = false;
                this.f_102810_.f_104207_ = false;
                this.f_102811_.f_104207_ = false;
                this.f_102812_.f_104207_ = false;
                this.bipedLegBody.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                this.leftRuff.f_104207_ = false;
                this.leftToe.f_104207_ = false;
                this.rightRuff.f_104207_ = false;
                this.rightToe.f_104207_ = false;
                break;
            }
            case FEET: {
                this.f_102808_.f_104207_ = false;
                this.f_102809_.f_104207_ = false;
                this.f_102810_.f_104207_ = false;
                this.f_102811_.f_104207_ = false;
                this.f_102812_.f_104207_ = false;
                this.bipedLegBody.f_104207_ = false;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                this.leftRuff.f_104207_ = true;
                this.leftToe.f_104207_ = true;
                this.rightRuff.f_104207_ = true;
                this.rightToe.f_104207_ = true;
                break;
            }
        }
        super.m_7695_(stack, builder, light, overlay, red, green, blue, scale);
    }
}

