/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.world.components.placements.AvoidLandmarkModifier;
import twilightforest.world.components.placements.ChunkBlanketingModifier;
import twilightforest.world.components.placements.ChunkCenterModifier;

public class TFPlacedFeatures {
    public static final Holder<PlacedFeature> PLACED_LAKE_LAVA = TFPlacedFeatures.register("lava_lake", TFConfiguredFeatures.LAKE_LAVA, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 10).build());
    public static final Holder<PlacedFeature> PLACED_LAKE_WATER = TFPlacedFeatures.register("water_lake", TFConfiguredFeatures.LAKE_WATER, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 4).build());
    public static final Holder<PlacedFeature> PLACED_SIMPLE_WELL = TFPlacedFeatures.register("simple_well", TFConfiguredFeatures.SIMPLE_WELL, (List<PlacementModifier>)ImmutableList.builder().build());
    public static final Holder<PlacedFeature> PLACED_FANCY_WELL = TFPlacedFeatures.register("fancy_well", TFConfiguredFeatures.FANCY_WELL, (List<PlacementModifier>)ImmutableList.builder().build());
    public static final Holder<PlacedFeature> PLACED_DRUID_HUT = TFPlacedFeatures.register("druid_hut", TFConfiguredFeatures.DRUID_HUT, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 105).build());
    public static final Holder<PlacedFeature> PLACED_GRAVEYARD = TFPlacedFeatures.register("graveyard", TFConfiguredFeatures.GRAVEYARD, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 75).build());
    public static final Holder<PlacedFeature> PLACED_BIG_MUSHGLOOM = TFPlacedFeatures.register("big_mushgloom", TFConfiguredFeatures.BIG_MUSHGLOOM, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build());
    public static final Holder<PlacedFeature> PLACED_FALLEN_LEAVES = TFPlacedFeatures.register("fallen_leaves", TFConfiguredFeatures.FALLEN_LEAVES, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build());
    public static final Holder<PlacedFeature> PLACED_FIDDLEHEAD = TFPlacedFeatures.register("fiddlehead", TFConfiguredFeatures.FIDDLEHEAD, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_FIRE_JET = TFPlacedFeatures.register("fire_jet", TFConfiguredFeatures.FIRE_JET, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_FOUNDATION = TFPlacedFeatures.register("foundation", TFConfiguredFeatures.FOUNDATION, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 100).build());
    public static final Holder<PlacedFeature> PLACED_GROVE_RUINS = TFPlacedFeatures.register("grove_ruins", TFConfiguredFeatures.GROVE_RUINS, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 105).build());
    public static final Holder<PlacedFeature> PLACED_HOLLOW_LOG = TFPlacedFeatures.register("hollow_log", TFConfiguredFeatures.HOLLOW_LOG, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 100).build());
    public static final Holder<PlacedFeature> PLACED_HOLLOW_STUMP = TFPlacedFeatures.register("hollow_stump", TFConfiguredFeatures.HOLLOW_STUMP, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build());
    public static final Holder<PlacedFeature> PLACED_HUGE_LILY_PAD = TFPlacedFeatures.register("huge_lily_pad", TFConfiguredFeatures.HUGE_LILY_PAD, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)20), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)10), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_HUGE_WATER_LILY = TFPlacedFeatures.register("huge_water_lily", TFConfiguredFeatures.HUGE_WATER_LILY, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)25), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_CICADA_LAMPPOST = TFPlacedFeatures.register("cicada_lamppost", TFConfiguredFeatures.CICADA_LAMPPOST, (List<PlacementModifier>)ImmutableList.builder().build());
    public static final Holder<PlacedFeature> PLACED_FIREFLY_LAMPPOST = TFPlacedFeatures.register("firefly_lamppost", TFConfiguredFeatures.FIREFLY_LAMPPOST, (List<PlacementModifier>)ImmutableList.builder().build());
    public static final Holder<PlacedFeature> PLACED_MAYAPPLE = TFPlacedFeatures.register("mayapple", TFConfiguredFeatures.MAYAPPLE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_MONOLITH = TFPlacedFeatures.register("monolith", TFConfiguredFeatures.MONOLITH, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 90).build());
    public static final Holder<PlacedFeature> PLACED_MUSHGLOOM_CLUSTER = TFPlacedFeatures.register("mushgloom_cluster", TFConfiguredFeatures.MUSHGLOOM_CLUSTER, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_MYCELIUM_BLOB = TFPlacedFeatures.register("mycelium_blob", TFConfiguredFeatures.MYCELIUM_BLOB, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 3).build());
    public static final Holder<PlacedFeature> PLACED_OUTSIDE_STALAGMITE = TFPlacedFeatures.register("outside_stalagmite", TFConfiguredFeatures.OUTSIDE_STALAGMITE, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 88).build());
    public static final Holder<PlacedFeature> PLACED_PLANT_ROOTS = TFPlacedFeatures.register("plant_roots", TFConfiguredFeatures.PLANT_ROOTS, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.m_191628_((int)4), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)10))}).build());
    public static final Holder<PlacedFeature> PLACED_PUMPKIN_LAMPPOST = TFPlacedFeatures.register("pumpkin_lamppost", TFConfiguredFeatures.PUMPKIN_LAMPPOST, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 1).build());
    public static final Holder<PlacedFeature> PLACED_SMOKER = TFPlacedFeatures.register("smoker", TFConfiguredFeatures.SMOKER, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_STONE_CIRCLE = TFPlacedFeatures.register("stone_circle", TFConfiguredFeatures.STONE_CIRCLE, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 105).build());
    public static final Holder<PlacedFeature> PLACED_THORNS = TFPlacedFeatures.register("thorns", TFConfiguredFeatures.THORNS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{ChunkBlanketingModifier.addThorns(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_TORCH_BERRIES = TFPlacedFeatures.register("torch_berries", TFConfiguredFeatures.TORCH_BERRIES, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), CountPlacement.m_191628_((int)8), AvoidLandmarkModifier.checkUnderground(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_TROLL_ROOTS = TFPlacedFeatures.register("troll_roots", TFConfiguredFeatures.TROLL_ROOTS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)60)), CountPlacement.m_191628_((int)8), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_VANILLA_ROOTS = TFPlacedFeatures.register("vanilla_roots", TFConfiguredFeatures.VANILLA_ROOTS, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 1, new PlacementModifier[]{CountPlacement.m_191628_((int)16), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0)), PlacementUtils.m_206493_((Block)((Block)TFBlocks.TORCHBERRY_PLANT.get()))}).build());
    public static final Holder<PlacedFeature> PLACED_WEBS = TFPlacedFeatures.register("webs", TFConfiguredFeatures.WEBS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)60), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_WOOD_ROOTS_SPREAD = TFPlacedFeatures.register("wood_roots", TFConfiguredFeatures.WOOD_ROOTS_SPREAD, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkUnderground(), 40, new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)0))}).build());
    public static final Holder<PlacedFeature> PLACED_SNOW_UNDER_TREES = TFPlacedFeatures.register("snow_under_trees", TFConfiguredFeatures.SNOW_UNDER_TREES, (List<PlacementModifier>)ImmutableList.builder().add((Object)BiomeFilter.m_191561_()).build());
    public static final Holder<PlacedFeature> PLACED_TF_OAK_FALLEN_LOG = TFPlacedFeatures.register("tf_oak_fallen_log", TFConfiguredFeatures.TF_OAK_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_CANOPY_FALLEN_LOG = TFPlacedFeatures.register("canopy_fallen_log", TFConfiguredFeatures.CANOPY_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_MANGROVE_FALLEN_LOG = TFPlacedFeatures.register("mangrove_fallen_log", TFConfiguredFeatures.MANGROVE_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_OAK_FALLEN_LOG = TFPlacedFeatures.register("oak_fallen_log", TFConfiguredFeatures.OAK_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_SPRUCE_FALLEN_LOG = TFPlacedFeatures.register("spruce_fallen_log", TFConfiguredFeatures.SPRUCE_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_BIRCH_FALLEN_LOG = TFPlacedFeatures.register("birch_fallen_log", TFConfiguredFeatures.BIRCH_FALLEN_LOG, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_SMALL_GRANITE = TFPlacedFeatures.register("small_granite", TFConfiguredFeatures.SMALL_GRANITE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build());
    public static final Holder<PlacedFeature> PLACED_SMALL_DIORITE = TFPlacedFeatures.register("small_diorite", TFConfiguredFeatures.SMALL_DIORITE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build());
    public static final Holder<PlacedFeature> PLACED_SMALL_ANDESITE = TFPlacedFeatures.register("small_andesite", TFConfiguredFeatures.SMALL_ANDESITE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64)), RarityFilter.m_191900_((int)10), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)5)}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_MUSHGLOOMS = TFPlacedFeatures.register("dark_mushglooms", TFConfiguredFeatures.DARK_MUSHGLOOMS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_PUMPKINS = TFPlacedFeatures.register("dark_pumpkins", TFConfiguredFeatures.DARK_PUMPKINS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)30), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_GRASS = TFPlacedFeatures.register("dark_grass", TFConfiguredFeatures.DARK_GRASS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)4), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_FERNS = TFPlacedFeatures.register("dark_ferns", TFConfiguredFeatures.DARK_FERNS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)4), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_MUSHROOMS = TFPlacedFeatures.register("dark_mushrooms", TFConfiguredFeatures.DARK_MUSHROOMS, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DARK_DEAD_BUSHES = TFPlacedFeatures.register("dark_dead_bushes", TFConfiguredFeatures.DARK_DEAD_BUSHES, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)15), PlacementUtils.f_195354_, BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_COAL_ORE = TFPlacedFeatures.register("legacy_coal_ore", TFConfiguredFeatures.LEGACY_COAL_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)127)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)20)}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_IRON_ORE = TFPlacedFeatures.register("legacy_iron_ore", TFConfiguredFeatures.LEGACY_IRON_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)63)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)20)}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_GOLD_ORE = TFPlacedFeatures.register("legacy_gold_ore", TFConfiguredFeatures.LEGACY_GOLD_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)31)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)2)}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_REDSTONE_ORE = TFPlacedFeatures.register("legacy_redstone_ore", TFConfiguredFeatures.LEGACY_REDSTONE_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)15)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)8)}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_DIAMOND_ORE = TFPlacedFeatures.register("legacy_diamond_ore", TFConfiguredFeatures.LEGACY_DIAMOND_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)15))).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_LAPIS_ORE = TFPlacedFeatures.register("legacy_lapis_ore", TFConfiguredFeatures.LEGACY_LAPIS_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)30)), InSquarePlacement.m_191715_()}).build());
    public static final Holder<PlacedFeature> PLACED_LEGACY_COPPER_ORE = TFPlacedFeatures.register("legacy_copper_ore", TFConfiguredFeatures.LEGACY_COPPER_ORE, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)96)), InSquarePlacement.m_191715_(), CountPlacement.m_191628_((int)6)}).build());
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> WELL_PLACER = TFConfiguredFeatures.register("well_placer", Feature.f_65754_, new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature(PLACED_FANCY_WELL, 0.05f)), PLACED_SIMPLE_WELL));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> LAMPPOST_PLACER = TFConfiguredFeatures.register("lamppost_placer", Feature.f_65754_, new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature(PLACED_CICADA_LAMPPOST, 0.1f)), PLACED_FIREFLY_LAMPPOST));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> DEFAULT_FALLEN_LOGS = TFConfiguredFeatures.register("default_fallen_logs", Feature.f_65754_, new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature(PLACED_BIRCH_FALLEN_LOG, 0.1f), (Object)new WeightedPlacedFeature(PLACED_OAK_FALLEN_LOG, 0.2f), (Object)new WeightedPlacedFeature(PLACED_CANOPY_FALLEN_LOG, 0.4f)), PLACED_TF_OAK_FALLEN_LOG));
    public static final Holder<PlacedFeature> PLACED_WELL_PLACER = TFPlacedFeatures.register("well_placer", WELL_PLACER, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkBoth(), 80).build());
    public static final Holder<PlacedFeature> PLACED_LAMPPOST_PLACER = TFPlacedFeatures.register("lamppost_placer", LAMPPOST_PLACER, (List<PlacementModifier>)TFPlacedFeatures.tfFeatureCheckArea(AvoidLandmarkModifier.checkSurface(), 2).build());
    public static final Holder<PlacedFeature> PLACED_DEFAULT_FALLEN_LOGS = TFPlacedFeatures.register("default_fallen_logs", DEFAULT_FALLEN_LOGS, (List<PlacementModifier>)TFPlacedFeatures.hollowLog(AvoidLandmarkModifier.checkSurface(), 40).build());
    public static final Holder<PlacedFeature> PLACED_FLOWER_PLACER = TFPlacedFeatures.register("flower_placer", TFConfiguredFeatures.FLOWER_PLACER, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)2), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_FLOWER_PLACER_ALT = TFPlacedFeatures.register("flower_placer_alt", TFConfiguredFeatures.FLOWER_PLACER_ALT, (List<PlacementModifier>)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.f_195354_, CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), RarityFilter.m_191900_((int)2), BiomeFilter.m_191561_()}).build());
    public static final Holder<PlacedFeature> PLACED_DEAD_CANOPY_TREE = TFPlacedFeatures.register("tree/dead_canopy_tree", TFConfiguredFeatures.DEAD_CANOPY_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_MANGROVE_TREE = TFPlacedFeatures.register("tree/mangrove_tree", TFConfiguredFeatures.MANGROVE_TREE, List.of(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)6), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), PlacementUtils.m_206493_((Block)((Block)TFBlocks.MANGROVE_SAPLING.get())), BiomeFilter.m_191561_()));
    public static final Holder<PlacedFeature> PLACED_TWILIGHT_OAK_TREE = TFPlacedFeatures.register("tree/twilight_oak_tree", TFConfiguredFeatures.TWILIGHT_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_LARGE_TWILIGHT_OAK_TREE = TFPlacedFeatures.register("tree/large_twilight_oak_tree", TFConfiguredFeatures.LARGE_TWILIGHT_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_FOREST_CANOPY_OAK_TREE = TFPlacedFeatures.register("tree/forest_canopy_oak_tree", TFConfiguredFeatures.FOREST_CANOPY_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)7, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_SAVANNAH_OAK_TREE = TFPlacedFeatures.register("tree/savannah_oak_tree", TFConfiguredFeatures.TWILIGHT_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_SAVANNAH_CANOPY_OAK_TREE = TFPlacedFeatures.register("tree/savannah_canopy_oak_tree", TFConfiguredFeatures.SAVANNAH_CANOPY_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_SWAMPY_OAK_TREE = TFPlacedFeatures.register("tree/swampy_oak_tree", TFConfiguredFeatures.SWAMPY_OAK_TREE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)4, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_DARKWOOD_TREE = TFPlacedFeatures.register("tree/darkwood_tree", TFConfiguredFeatures.DARKWOOD_TREE, List.of(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, new AvoidLandmarkModifier(true, false, 16), PlacementUtils.m_206493_((Block)((Block)TFBlocks.DARKWOOD_SAPLING.get())), BiomeFilter.m_191561_()));
    public static final Holder<PlacedFeature> PLACED_SNOWY_SPRUCE_TREE = TFPlacedFeatures.register("tree/snowy_spruce", TFConfiguredFeatures.SNOWY_SPRUCE_TREE, TFPlacedFeatures.tfTreeCheckArea(Blocks.f_50747_.m_49966_()));
    public static final Holder<PlacedFeature> PLACED_HOLLOW_OAK_TREE = TFPlacedFeatures.register("tree/hollow_oak", TFConfiguredFeatures.HOLLOW_TREE, List.of(SurfaceWaterDepthFilter.m_191950_((int)0), RarityFilter.m_191900_((int)35), PlacementUtils.f_195355_, ChunkCenterModifier.center(), new AvoidLandmarkModifier(true, false, 32), PlacementUtils.m_206493_((Block)((Block)TFBlocks.HOLLOW_OAK_SAPLING.get())), BiomeFilter.m_191561_()));
    public static final Holder<PlacedFeature> PLACED_CANOPY_TREES = TFPlacedFeatures.register("tree/selector/canopy_trees", TFConfiguredFeatures.CANOPY_TREES, TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_DENSE_CANOPY_TREES = TFPlacedFeatures.register("tree/selector/dense_canopy_trees", TFConfiguredFeatures.DENSE_CANOPY_TREES, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_FIREFLY_FOREST_TREES = TFPlacedFeatures.register("tree/selector/firefly_forest_trees", TFConfiguredFeatures.FIREFLY_FOREST_TREES, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_DARK_FOREST_TREES = TFPlacedFeatures.register("tree/selector/dark_forest_trees", TFConfiguredFeatures.DARKWOOD_TREE, TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.m_195364_((int)8, (float)0.1f, (int)1)));
    public static final Holder<PlacedFeature> PLACED_DARK_FOREST_TREE_MIX = TFPlacedFeatures.register("tree/selector/dark_forest_tree_mix", TFConfiguredFeatures.DARK_FOREST_TREES, TFPlacedFeatures.darkForestTreeCheck(PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1)));
    public static final Holder<PlacedFeature> PLACED_HIGHLANDS_TREES = TFPlacedFeatures.register("tree/selector/highlands_trees", TFConfiguredFeatures.HIGHLANDS_TREES, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), Blocks.f_50747_.m_49966_()));
    public static final Holder<PlacedFeature> PLACED_ENCHANTED_FOREST_TREES = TFPlacedFeatures.register("tree/selector/enchanted_forest_trees", TFConfiguredFeatures.ENCHANTED_FOREST_TREES, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.RAINBOW_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_SNOWY_FOREST_TREES = TFPlacedFeatures.register("tree/selector/snowy_forest_trees", TFConfiguredFeatures.SNOWY_FOREST_TREES, List.of(PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), EnvironmentScanPlacement.m_191653_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_152499_})), (int)8), BlockPredicateFilter.m_191576_((BlockPredicate)TreePlacements.f_195379_), BiomeFilter.m_191561_()));
    public static final Holder<PlacedFeature> PLACED_VANILLA_TF_TREES = TFPlacedFeatures.register("tree/selector/vanilla_trees", TFConfiguredFeatures.VANILLA_TF_TREES, TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.TWILIGHT_OAK_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_VANILLA_TF_BIG_MUSH = TFPlacedFeatures.register("tree/selector/vanilla_mushrooms", TFConfiguredFeatures.VANILLA_TF_BIG_MUSH, TFPlacedFeatures.tfTreeCheckArea(((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_CANOPY_MUSHROOMS_SPARSE = TFPlacedFeatures.register("mushroom/canopy_mushrooms_sparse", TFConfiguredFeatures.CANOPY_MUSHROOMS_SPARSE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)3, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));
    public static final Holder<PlacedFeature> PLACED_CANOPY_MUSHROOMS_DENSE = TFPlacedFeatures.register("mushroom/canopy_mushrooms_dense", TFConfiguredFeatures.CANOPY_MUSHROOMS_DENSE, TFPlacedFeatures.tfTreeCheckArea(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1), ((SaplingBlock)TFBlocks.CANOPY_SAPLING.get()).m_49966_()));

    private static List<PlacementModifier> tfTreeCheckArea(BlockState sapling) {
        return List.of(InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, AvoidLandmarkModifier.checkSurface(), PlacementUtils.m_206493_((Block)sapling.m_60734_()), BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> tfTreeCheckArea(PlacementModifier count, BlockState sapling) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.m_191715_(), (Object)SurfaceWaterDepthFilter.m_191950_((int)0), (Object)PlacementUtils.f_195355_, (Object)((Object)AvoidLandmarkModifier.checkSurface()), (Object)PlacementUtils.m_206493_((Block)sapling.m_60734_()), (Object)BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> darkForestTreeCheck(PlacementModifier count) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.m_191715_(), (Object)SurfaceWaterDepthFilter.m_191950_((int)0), (Object)PlacementUtils.f_195355_, (Object)((Object)new AvoidLandmarkModifier(true, false, 10)), (Object)BiomeFilter.m_191561_());
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, filter, BiomeFilter.m_191561_()});
    }

    private static ImmutableList.Builder<PlacementModifier> tfFeatureCheckArea(AvoidLandmarkModifier filter, int rarity, PlacementModifier ... extra) {
        return ImmutableList.builder().add((Object[])extra).add((Object[])new PlacementModifier[]{filter, RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    private static ImmutableList.Builder<PlacementModifier> hollowLog(AvoidLandmarkModifier filter, int rarity) {
        return ImmutableList.builder().add((Object[])new PlacementModifier[]{RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195355_, filter});
    }

    public static Holder<PlacedFeature> register(String name, Holder<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placements) {
        return BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_194653_, (String)TwilightForestMod.prefix(name).toString(), (Object)new PlacedFeature(Holder.m_205706_(feature), List.copyOf(placements)));
    }
}

