/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TrainStatus {
    Train train;
    boolean navigation;
    boolean track;
    boolean conductor;
    List<Component> queued = new ArrayList<Component>();

    public TrainStatus(Train train) {
        this.train = train;
    }

    public void failedNavigation() {
        if (this.navigation) {
            return;
        }
        this.displayInformation("no_path", false, new Object[0]);
        this.navigation = true;
    }

    public void failedNavigationNoTarget(String filter) {
        if (this.navigation) {
            return;
        }
        this.displayInformation("no_match", false, filter);
        this.navigation = true;
    }

    public void successfulNavigation() {
        if (!this.navigation) {
            return;
        }
        this.displayInformation("navigation_success", true, new Object[0]);
        this.navigation = false;
    }

    public void foundConductor() {
        if (!this.conductor) {
            return;
        }
        this.displayInformation("found_driver", true, new Object[0]);
        this.conductor = false;
    }

    public void missingConductor() {
        if (this.conductor) {
            return;
        }
        this.displayInformation("missing_driver", false, new Object[0]);
        this.conductor = true;
    }

    public void missingCorrectConductor() {
        if (this.conductor) {
            return;
        }
        this.displayInformation("opposite_driver", false, new Object[0]);
        this.conductor = true;
    }

    public void manualControls() {
        this.displayInformation("paused_for_manual", true, new Object[0]);
    }

    public void failedMigration() {
        if (this.track) {
            return;
        }
        this.displayInformation("track_missing", false, new Object[0]);
        this.track = true;
    }

    public void highStress() {
        if (this.track) {
            return;
        }
        this.displayInformation("coupling_stress", false, new Object[0]);
        this.track = true;
    }

    public void doublePortal() {
        if (this.track) {
            return;
        }
        this.displayInformation("double_portal", false, new Object[0]);
        this.track = true;
    }

    public void endOfTrack() {
        if (this.track) {
            return;
        }
        this.displayInformation("end_of_track", false, new Object[0]);
        this.track = true;
    }

    public void crash() {
        this.displayInformation("collision", false, new Object[0]);
    }

    public void successfulMigration() {
        if (!this.track) {
            return;
        }
        this.displayInformation("back_on_track", true, new Object[0]);
        this.track = false;
    }

    public void trackOK() {
        this.track = false;
    }

    public void tick(Level level) {
        if (this.queued.isEmpty()) {
            return;
        }
        LivingEntity owner = this.train.getOwner(level);
        if (owner == null) {
            return;
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            player.m_5661_((Component)Lang.translateDirect("train.status", this.train.name).m_130940_(ChatFormatting.GOLD), false);
            this.queued.forEach(c -> player.m_5661_(c, false));
        }
        this.queued.clear();
    }

    public void displayInformation(String key, boolean itsAGoodThing, Object ... args) {
        this.queued.add((Component)Components.literal(" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Lang.translateDirect("train.status." + key, args).m_130938_(st -> st.m_178520_(itsAGoodThing ? 14019778 : 16765876))));
        if (this.queued.size() > 3) {
            this.queued.remove(0);
        }
    }

    public void newSchedule() {
        this.navigation = false;
        this.conductor = false;
    }
}

