/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    private ConfigHandler() {
    }

    @SubscribeEvent
    public static void onModConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SERVER_SPEC && SERVER_SPEC.isLoaded()) {
            ConfigHandler.loadEffects(ConfigHandler.SERVER.taserEffectsValue, ConfigHandler.SERVER.taserEffects);
            ConfigHandler.loadEffects(ConfigHandler.SERVER.poweredTaserEffectsValue, ConfigHandler.SERVER.poweredTaserEffects);
        }
    }

    private static void loadEffects(ForgeConfigSpec.ConfigValue<List<? extends String>> effectsValue, List<Supplier<MobEffectInstance>> effects) {
        effects.clear();
        for (String entry : (List)effectsValue.get()) {
            String[] split = entry.split("\\|");
            if (split.length == 3) {
                int duration = Integer.parseInt(split[1]);
                int amplifier = Integer.parseInt(split[2]);
                if (!ConfigHandler.validateValue(duration, entry) || !ConfigHandler.validateValue(amplifier, entry)) continue;
                ResourceLocation effectLocation = new ResourceLocation(split[0]);
                if (!ForgeRegistries.MOB_EFFECTS.containsKey(effectLocation)) {
                    LOGGER.warn("Effect \"{}\" does not exist, skipping", (Object)effectLocation);
                    continue;
                }
                effects.add(() -> new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation), duration, amplifier - 1));
                continue;
            }
            LOGGER.warn("Not enough information provided for effect \"{}\", skipping", (Object)entry);
        }
    }

    private static boolean validateValue(int value, String entry) {
        if (value <= 0) {
            LOGGER.warn("Value \"{}\" cannot be less than or equal to zero for entry \"{}\", skipping", (Object)value, (Object)entry);
            return false;
        }
        return true;
    }

    public static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> value) {
        try {
            return (T)value.get();
        }
        catch (Exception e) {
            if (!FMLLoader.getLaunchHandler().isData()) {
                LOGGER.warn("Error when getting config value with getOrDefault! Please report this.");
                e.printStackTrace();
            }
            return (T)value.getDefault();
        }
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Server {
        public ForgeConfigSpec.DoubleValue codebreakerChance;
        public ForgeConfigSpec.BooleanValue allowAdminTool;
        public ForgeConfigSpec.BooleanValue shouldSpawnFire;
        public ForgeConfigSpec.BooleanValue ableToBreakMines;
        public ForgeConfigSpec.BooleanValue smallerMineExplosion;
        public ForgeConfigSpec.BooleanValue mineExplodesWhenInCreative;
        public ForgeConfigSpec.BooleanValue mineExplosionsBreakBlocks;
        public ForgeConfigSpec.IntValue laserBlockRange;
        public ForgeConfigSpec.IntValue inventoryScannerRange;
        public ForgeConfigSpec.IntValue maxAlarmRange;
        public ForgeConfigSpec.BooleanValue allowBlockClaim;
        public ForgeConfigSpec.BooleanValue respectInvisibility;
        public ForgeConfigSpec.BooleanValue reinforcedBlockTint;
        public ForgeConfigSpec.BooleanValue forceReinforcedBlockTint;
        public ForgeConfigSpec.BooleanValue retinalScannerFace;
        public ForgeConfigSpec.BooleanValue enableTeamOwnership;
        public ForgeConfigSpec.BooleanValue disableThanksMessage;
        public ForgeConfigSpec.BooleanValue trickScannersWithPlayerHeads;
        public ForgeConfigSpec.DoubleValue taserDamage;
        public ForgeConfigSpec.DoubleValue poweredTaserDamage;
        public ForgeConfigSpec.DoubleValue laserDamage;
        public ForgeConfigSpec.IntValue incorrectPasscodeDamage;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> sentryAttackableEntitiesAllowlist;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> sentryAttackableEntitiesDenylist;
        private ForgeConfigSpec.ConfigValue<List<? extends String>> taserEffectsValue;
        private ForgeConfigSpec.ConfigValue<List<? extends String>> poweredTaserEffectsValue;
        public final List<Supplier<MobEffectInstance>> taserEffects = new ArrayList<Supplier<MobEffectInstance>>();
        public final List<Supplier<MobEffectInstance>> poweredTaserEffects = new ArrayList<Supplier<MobEffectInstance>>();

        Server(ForgeConfigSpec.Builder builder) {
            this.codebreakerChance = builder.comment(new String[]{"The chance for the codebreaker to successfully hack a block. 0.33 is 33%. Set to a negative value to disable the codebreaker.", "Using the codebreaker when this is set to 0.0 will still damage the item, while negative values do not damage it."}).defineInRange("codebreaker_chance", 0.33, -1.0, 1.0);
            this.allowAdminTool = builder.comment("Can the admin tool be used?").define("allowAdminTool", true);
            this.shouldSpawnFire = builder.comment("Should mines spawn fire after exploding?").define("shouldSpawnFire", true);
            this.ableToBreakMines = builder.comment("Should players be able to break a mine without it exploding?").define("ableToBreakMines", true);
            this.smallerMineExplosion = builder.comment("Should mines' explosions be smaller than usual.").define("smallerMineExplosion", false);
            this.mineExplodesWhenInCreative = builder.comment("Should mines explode if broken while in Creative mode?").define("mineExplodesWhenInCreative", true);
            this.mineExplosionsBreakBlocks = builder.comment("Set this to false if you want mines to not break blocks when they explode. If this is set to true, the blockExplosionDropDecay gamerule will be respected").define("mineExplosionsBreakBlocks", true);
            this.laserBlockRange = builder.comment("From how many blocks away can a laser block connect to another laser block?").defineInRange("laserBlockRange", 5, 0, Integer.MAX_VALUE);
            this.inventoryScannerRange = builder.comment("From how many blocks away can an inventory scanner connect to another inventory scanner?").defineInRange("inventoryScannerRange", 2, 0, Integer.MAX_VALUE);
            this.maxAlarmRange = builder.comment("What is the maximum value that can be set for an alarm's range option? Do note, that this may be limited by chunk loading distance. Higher values may also not be finetuneable.").defineInRange("maxAlarmRange", 100, 1, Integer.MAX_VALUE);
            this.allowBlockClaim = builder.comment("Allow claiming unowned blocks?").define("allowBlockClaim", false);
            this.respectInvisibility = builder.comment("Should the sentry/inventory scanner/laser block/etc. ignore players and entities that are invisible?").define("respect_invisibility", false);
            this.reinforcedBlockTint = builder.comment("Should reinforced blocks' textures be slightly darker than their vanilla counterparts? This does nothing unless force_reinforced_block_tint is set to true.").define("reinforced_block_tint", true);
            this.forceReinforcedBlockTint = builder.comment("Set this to true if you want to force the setting of reinforced_block_tint for players.").define("force_reinforced_block_tint", false);
            this.retinalScannerFace = builder.comment("Display owner face on retinal scanner?").define("retinalScannerFace", true);
            this.enableTeamOwnership = builder.comment(new String[]{"Set this to true to enable every player on a scoreboard team (or FTB Teams party) to own the blocks of every other player on the same team.", "This enables players on the same team to break each other's reinforced blocks, change options, add/remove modules, and have access to all other owner-restricted things."}).define("enable_team_ownership", false);
            this.disableThanksMessage = builder.comment(new String[]{"Set this to true to disable sending the message that SecurityCraft shows when a player joins.", "Note, that this stops showing the message for every player, even those that want to see them."}).define("disable_thanks_message", false);
            this.trickScannersWithPlayerHeads = builder.comment("Set this to true if you want players wearing a different player's skull to be able to trick their retinal scanners and scanner doors into activating.").define("trick_scanners_with_player_heads", false);
            this.taserDamage = builder.comment("Set the amount of damage the taser inflicts onto the mobs it hits. Default is half a heart.").defineInRange("taser_damage", 1.0, 0.0, Double.MAX_VALUE);
            this.poweredTaserDamage = builder.comment("Set the amount of damage the powered taser inflicts onto the mobs it hits. Default is one heart.").defineInRange("powered_taser_damage", 2.0, 0.0, Double.MAX_VALUE);
            this.taserEffectsValue = builder.comment(new String[]{"Add effects to this list that you want the taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."}).defineList("taser_effects", List.of("minecraft:weakness|200|2", "minecraft:nausea|200|2", "minecraft:slowness|200|2"), String.class::isInstance);
            this.poweredTaserEffectsValue = builder.comment(new String[]{"Add effects to this list that you want the powered taser to inflict onto the mobs it hits. One entry corresponds to one effect, and is formatted like this:", "effect_namespace:effect_path|duration|amplifier", "Example: The entry \"minecraft:slowness|20|1\" defines slowness 1 for 1 second (20 ticks = 1 second)."}).defineList("powered_taser_effects", List.of("minecraft:weakness|400|5", "minecraft:nausea|400|5", "minecraft:slowness|400|5"), String.class::isInstance);
            this.laserDamage = builder.comment("Defines the damage inflicted to an entity if it passes through a laser with installed harming module. This is given in health points, meaning 2 health points = 1 heart").defineInRange("laser_damage", 10.0, 0.0, Double.MAX_VALUE);
            this.incorrectPasscodeDamage = builder.comment(new String[]{"Defines the damage that a block requiring a passcode deals to the player, if the player enters an incorrect code. This only works if a harming module is installed.", "Default is two hearts of damage."}).defineInRange("incorrectPasscodeDamage", 4, 1, Integer.MAX_VALUE);
            this.sentryAttackableEntitiesAllowlist = builder.comment("Add entities to this list that the Sentry currently does not attack, but that you want the Sentry to attack. The denylist takes priority over the allowlist.").defineList("sentry_attackable_entities_allowlist", List.of(), String.class::isInstance);
            this.sentryAttackableEntitiesDenylist = builder.comment("Add entities to this list that the Sentry currently attacks, but that you want the Sentry to NOT attack. The denylist takes priority over the allowlist.").defineList("sentry_attackable_entities_denylist", List.of(), String.class::isInstance);
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue sayThanksMessage;
        public ForgeConfigSpec.DoubleValue cameraSpeed;
        public ForgeConfigSpec.BooleanValue reinforcedBlockTint;
        public ForgeConfigSpec.IntValue reinforcedBlockTintColor;

        Client(ForgeConfigSpec.Builder builder) {
            this.sayThanksMessage = builder.comment("Display a 'tip' message at spawn?").define("sayThanksMessage", true);
            this.cameraSpeed = builder.comment("How fast can you rotate when mounted to a camera and holding W-A-S-D?").defineInRange("cameraSpeed", 2.0, 0.0, Double.MAX_VALUE);
            this.reinforcedBlockTint = builder.comment("Should reinforced blocks' textures be slightly darker than their vanilla counterparts? This setting can be overridden by servers.").define("reinforced_block_tint", true);
            this.reinforcedBlockTintColor = builder.comment(new String[]{"Set the color that reinforced blocks' textures have when reinforced_block_tint is enabled. This cannot be overridden by servers, and will be applied the same to all blocks. Grayscale values look best.", "Format: 0xRRGGBB"}).defineInRange("reinforced_block_tint_color", 0x999999, 0, 0xFFFFFF);
        }
    }
}

