/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    public static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);
    private static final Component REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);

    private SCClientEventHandler() {
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Vec3 camPos = event.getCamera().m_90583_();
            PoseStack pose = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedBlockEntities((Level)level)) {
                BlockChangeDetectorBlockEntity bcd;
                BlockEntity be = level.m_7702_(bcdPos);
                if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Player)mc.f_91074_)) continue;
                for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                    BlockPos pos = changeEntry.pos();
                    pose.m_85836_();
                    pose.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
                    ClientUtils.renderBoxInLevel(BCDBuffer.INSTANCE, pose.m_85850_().m_252922_(), 0, 1, 0, 1, 1, bcd.getColor());
                    pose.m_85849_();
                }
            }
            mc.m_91269_().m_110104_().m_109911_();
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        SecurityCamera camera;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && (camera = (SecurityCamera)Minecraft.m_91087_().f_91075_).getScreenshotSoundCooldown() == 0) {
            camera.setScreenshotSoundCooldown(7);
            Minecraft.m_91087_().f_91073_.m_245747_(player.m_20183_(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            Minecraft mc = Minecraft.m_91087_();
            InteractionHand hand = event.getHand();
            if (mc.f_91074_.m_21120_(hand).m_150930_((Item)SCContent.CAMERA_MONITOR.get())) {
                ((Item)SCContent.CAMERA_MONITOR.get()).m_7203_((Level)mc.f_91073_, (Player)mc.f_91074_, hand);
            }
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    public static void cameraOverlay(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos pos = mc.f_91075_.m_20183_();
        Window window = mc.m_91268_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            return;
        }
        SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
        Font font = Minecraft.m_91087_().f_91062_;
        Options settings = Minecraft.m_91087_().f_91066_;
        boolean hasRedstoneModule = be.isModuleEnabled(ModuleType.REDSTONE);
        BlockState state = level.m_8055_(pos);
        MutableComponent lookAround = Utils.localize("gui.securitycraft:camera.lookAround", settings.f_92085_.m_90863_(), settings.f_92086_.m_90863_(), settings.f_92087_.m_90863_(), settings.f_92088_.m_90863_());
        MutableComponent exit = Utils.localize("gui.securitycraft:camera.exit", settings.f_92090_.m_90863_());
        MutableComponent zoom = Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.m_90863_(), KeyBindings.cameraZoomOut.m_90863_());
        MutableComponent nightVision = Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.m_90863_());
        MutableComponent redstone = Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.m_90863_());
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (be.m_8077_()) {
            Component cameraName = be.m_7770_();
            guiGraphics.m_280614_(font, cameraName, window.m_85445_() - font.m_92852_((FormattedText)cameraName) - 8, 25, 0xFFFFFF, true);
            timeY += 10;
        }
        guiGraphics.m_280056_(font, time, window.m_85445_() - font.m_92895_(time) - 4, timeY, 0xFFFFFF, true);
        guiGraphics.m_280614_(font, (Component)lookAround, window.m_85445_() - font.m_92852_((FormattedText)lookAround) - 8, window.m_85446_() - 80, 0xFFFFFF, true);
        guiGraphics.m_280614_(font, (Component)exit, window.m_85445_() - font.m_92852_((FormattedText)exit) - 8, window.m_85446_() - 70, 0xFFFFFF, true);
        guiGraphics.m_280614_(font, (Component)zoom, window.m_85445_() - font.m_92852_((FormattedText)zoom) - 8, window.m_85446_() - 60, 0xFFFFFF, true);
        guiGraphics.m_280614_(font, (Component)nightVision, window.m_85445_() - font.m_92852_((FormattedText)nightVision) - 8, window.m_85446_() - 50, 0xFFFFFF, true);
        guiGraphics.m_280614_(font, (Component)redstone, window.m_85445_() - font.m_92852_((FormattedText)redstone) - 8, window.m_85446_() - 40, hasRedstoneModule ? 0xFFFFFF : 0xFF3377, true);
        guiGraphics.m_280614_(font, REDSTONE_NOTE, window.m_85445_() - font.m_92852_((FormattedText)REDSTONE_NOTE) - 8, window.m_85446_() - 30, hasRedstoneModule ? 0xFFFFFF : 0xFF3377, true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(CAMERA_DASHBOARD, 5, 0, 0, 0, 90, 20);
        guiGraphics.m_280218_(CAMERA_DASHBOARD, window.m_85445_() - 70, 5, 190, 0, 65, 30);
        if (!mc.f_91074_.m_21023_(MobEffects.f_19611_)) {
            guiGraphics.m_280218_(CAMERA_DASHBOARD, 28, 4, 90, 12, 16, 11);
        } else {
            guiGraphics.m_280163_(NIGHT_VISION, 27, -1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        if (state.m_60746_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0) {
            if (!hasRedstoneModule) {
                CameraRedstoneModuleState.NOT_INSTALLED.render(guiGraphics, 12, 2);
            } else {
                CameraRedstoneModuleState.DEACTIVATED.render(guiGraphics, 12, 2);
            }
        } else {
            CameraRedstoneModuleState.ACTIVATED.render(guiGraphics, 12, 2);
        }
    }

    private static enum BCDBuffer implements MultiBufferSource
    {
        INSTANCE;

        private final RenderType overlayLines = new OverlayLines(RenderType.m_110504_());

        public VertexConsumer m_6299_(RenderType renderType) {
            return Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(this.overlayLines);
        }

        private static class OverlayLines
        extends RenderType {
            private final RenderType normalLines;

            private OverlayLines(RenderType normalLines) {
                super("overlay_lines", normalLines.m_110508_(), normalLines.m_173186_(), normalLines.m_110507_(), normalLines.m_110405_(), normalLines.f_110393_, () -> ((RenderType)normalLines).m_110185_(), () -> ((RenderType)normalLines).m_110188_());
                this.normalLines = normalLines;
            }

            public void m_110185_() {
                this.normalLines.m_110185_();
                RenderTarget renderTarget = Minecraft.m_91087_().f_91060_.m_109827_();
                if (renderTarget != null) {
                    renderTarget.m_83947_(false);
                }
            }

            public void m_110188_() {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
                this.normalLines.m_110188_();
            }
        }
    }
}

