/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.UUID;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public interface IPasscodeProtected
extends ICodebreakable {
    default public void openPasscodeGUI(Level level, BlockPos pos, Player player) {
        if (!level.f_46443_ && this.getPasscode() != null) {
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSCODE, pos));
        }
    }

    default public boolean verifyPasscodeSet(Level level, BlockPos pos, IOwnable ownable, Player player) {
        if (!level.f_46443_) {
            if (this.getPasscode() != null) {
                return true;
            }
            if (ownable.isOwnedBy(player)) {
                SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSCODE, pos));
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237113_((String)"SecurityCraft"), Utils.localize("messages.securitycraft:passcodeProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
        return false;
    }

    @Override
    default public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.getPasscode() == null) {
            PlayerUtils.sendMessageToPlayer(player, Component.m_237113_((String)"SecurityCraft"), Utils.localize("messages.securitycraft:passcodeProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            return false;
        }
        return true;
    }

    @Override
    default public void useCodebreaker(BlockState state, Player player) {
        this.activate(player);
    }

    public void activate(Player var1);

    public byte[] getPasscode();

    default public void hashAndSetPasscode(String passcode) {
        this.hashAndSetPasscode(passcode, PasscodeUtils.generateSalt());
    }

    default public void hashAndSetPasscode(String passcode, byte[] salt) {
        SaltData.removeSalt(this.getSaltKey());
        this.setSaltKey(SaltData.putSalt(salt));
        PasscodeUtils.hashPasscode(passcode, salt, this::setPasscode);
    }

    public void setPasscode(byte[] var1);

    default public void loadSaltKey(CompoundTag tag) {
        UUID saltKey = tag.m_128441_("saltKey") ? tag.m_128342_("saltKey") : null;
        String passcode = tag.m_128461_(tag.m_128425_("Passcode", 8) ? "Passcode" : "passcode");
        if (passcode.length() == 32 && !SaltData.containsKey(saltKey)) {
            PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
        } else {
            this.setSaltKey(saltKey);
        }
    }

    default public void loadPasscode(CompoundTag tag) {
        String passcode = tag.m_128461_(tag.m_128425_("Passcode", 8) ? "Passcode" : "passcode");
        if (!passcode.isEmpty()) {
            if (passcode.length() <= 20) {
                this.hashAndSetPasscode(PasscodeUtils.hashPasscodeWithoutSalt(passcode));
            } else {
                this.setPasscode(PasscodeUtils.stringToBytes(passcode));
            }
        }
    }

    default public byte[] getSalt() {
        return SaltData.getSalt(this.getSaltKey());
    }

    public UUID getSaltKey();

    public void setSaltKey(UUID var1);

    public void startCooldown();

    public boolean isOnCooldown();

    public long getCooldownEnd();

    default public void onIncorrectPasscodeEntered(Player player, String incorrectCode) {
        IPasscodeProtected iPasscodeProtected = this;
        if (iPasscodeProtected instanceof IModuleInventory) {
            IModuleInventory moduleInv = (IModuleInventory)((Object)iPasscodeProtected);
            if (moduleInv.isModuleEnabled(ModuleType.SMART)) {
                this.startCooldown();
            }
            if (moduleInv.isModuleEnabled(ModuleType.HARMING) && player.m_6469_(CustomDamageSources.incorrectPasscode(player.m_9236_().m_9598_()), (float)((Integer)ConfigHandler.SERVER.incorrectPasscodeDamage.get()).intValue())) {
                player.m_6915_();
            }
        }
    }
}

