/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.List;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface IViewActivated {
    default public void checkView(Level level, BlockPos pos) {
        if (this.getViewCooldown() > 0) {
            this.setViewCooldown(this.getViewCooldown() - 1);
            return;
        }
        double maximumDistance = this.getMaximumDistance();
        List entities = level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(maximumDistance), e -> e.m_142065_() && !EntityUtils.isInvisible(e) && (!this.activatedOnlyByPlayer() || e instanceof Player));
        for (LivingEntity entity : entities) {
            double eyeHeight = entity.m_20192_();
            Vec3 lookVec = new Vec3(entity.m_20185_() + entity.m_20154_().f_82479_ * maximumDistance, eyeHeight + entity.m_20186_() + entity.m_20154_().f_82480_ * maximumDistance, entity.m_20189_() + entity.m_20154_().f_82481_ * maximumDistance);
            BlockHitResult hitResult = level.m_45547_(new ClipContext(new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_()), lookVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
            if (hitResult == null || hitResult.m_82425_().m_123341_() != pos.m_123341_() || hitResult.m_82425_().m_123342_() != pos.m_123342_() || hitResult.m_82425_().m_123343_() != pos.m_123343_() || !this.onEntityViewed(entity, hitResult)) continue;
            this.setViewCooldown(this.getDefaultViewCooldown());
        }
    }

    default public int getDefaultViewCooldown() {
        return 30;
    }

    public int getViewCooldown();

    public void setViewCooldown(int var1);

    public boolean onEntityViewed(LivingEntity var1, BlockHitResult var2);

    default public boolean activatedOnlyByPlayer() {
        return true;
    }

    public double getMaximumDistance();
}

