/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadBlockEntity
extends DisguisableBlockEntity
implements IPasscodeProtected,
ILockable {
    private byte[] passcode;
    private UUID saltKey;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            if (!KeypadBlockEntity.this.isDisabled()) {
                KeypadBlockEntity.this.f_58857_.m_46597_(KeypadBlockEntity.this.f_58858_, (BlockState)KeypadBlockEntity.this.m_58900_().m_61124_((Property)KeypadBlock.POWERED, (Comparable)((Boolean)this.get())));
                KeypadBlockEntity.this.f_58857_.m_46672_(KeypadBlockEntity.this.f_58858_, (Block)SCContent.KEYPAD.get());
            }
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.SignalLengthOption(60);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;

    public KeypadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        long cooldownLeft;
        super.m_183515_(tag);
        if (this.saltKey != null) {
            tag.m_128362_("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.m_128359_("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        tag.m_128356_("cooldownLeft", (cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis()) <= 0L ? -1L : cooldownLeft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadBlock) {
            KeypadBlock block2 = (KeypadBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.m_61143_((Property)KeypadBlock.POWERED) == false && IPasscodeProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled")) {
            boolean isDisabled = (Boolean)((Option.BooleanOption)option).get();
            if (isDisabled && ((Boolean)this.m_58900_().m_61143_((Property)KeypadBlock.POWERED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)KeypadBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            } else if (!isDisabled && ((Boolean)this.isAlwaysActive.get()).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)KeypadBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.m_6596_();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

