/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasscodeProtected {
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private byte[] passcode;
    private UUID saltKey;

    public KeypadDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        long cooldownLeft;
        super.m_183515_(tag);
        if (this.saltKey != null) {
            tag.m_128362_("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.m_128359_("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        tag.m_128356_("cooldownLeft", (cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis()) <= 0L ? -1L : cooldownLeft);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadDoorBlock) {
            KeypadDoorBlock block2 = (KeypadDoorBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, player, this.getSignalLength());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) == false && IPasscodeProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.m_6596_();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
        this.m_6596_();
    }

    @Override
    public void startCooldown() {
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        this.runForOtherHalf(otherHalf -> otherHalf.startCooldown(start));
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }

    @Override
    public void setCustomName(Component customName) {
        super.setCustomName(customName);
        if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            ((INameSetter)this.f_58857_.m_7702_(this.f_58858_.m_7494_())).setCustomName(customName);
        }
    }

    public void runForOtherHalf(Consumer<KeypadDoorBlockEntity> action) {
        BlockEntity be = null;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        } else if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        if (be instanceof KeypadDoorBlockEntity) {
            KeypadDoorBlockEntity otherHalf = (KeypadDoorBlockEntity)be;
            action.accept(otherHalf);
        }
    }
}

