/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.ProtectoBlock;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ProtectoBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity {
    private static final int ATTACK_RANGE = 10;
    private static final int SLOW_SPEED = 200;
    private static final int FAST_SPEED = 100;
    private int cooldown = 0;
    private int ticksBetweenAttacks = this.isModuleEnabled(ModuleType.SPEED) ? 100 : 200;
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);

    public ProtectoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PROTECTO_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.isDisabled() || this.cooldown++ < this.ticksBetweenAttacks) {
            return;
        }
        if (level.m_46471_() && level.m_46861_(pos)) {
            List entities = level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(10.0));
            if (!((Boolean)state.m_61143_((Property)ProtectoBlock.ACTIVATED)).booleanValue()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            }
            if (!entities.isEmpty()) {
                boolean shouldDeactivate = false;
                for (LivingEntity entity : entities) {
                    OwnableEntity ownableEntity;
                    Player player;
                    if (entity instanceof Sentry || EntityUtils.isInvisible(entity) || entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_() || this.isOwnedBy(player) && this.ignoresOwner() || this.isAllowed((Entity)entity)) || entity instanceof OwnableEntity && this.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity)) continue;
                    if (!level.f_46443_) {
                        level.m_7967_((Entity)LevelUtils.createLightning(level, entity.m_20182_(), false));
                    }
                    shouldDeactivate = true;
                }
                if (shouldDeactivate) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                }
            }
            this.cooldown = 0;
        } else if (((Boolean)state.m_61143_((Property)ProtectoBlock.ACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ProtectoBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.SPEED) {
            this.ticksBetweenAttacks = 100;
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.SPEED) {
            this.ticksBetweenAttacks = 200;
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

