/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.List;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class SpecialDoorBlockEntity
extends LinkableBlockEntity
implements ILockable {
    protected Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    protected Option.IntOption signalLength = new Option.IntOption("signalLength", this.defaultSignalLength(), 0, 400, 5, true);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    protected SpecialDoorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        SpecialDoorBlockEntity be;
        pos = state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos.m_7494_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpecialDoorBlockEntity && SpecialDoorBlockEntity.isLinkedWith(this, be = (SpecialDoorBlockEntity)blockEntity)) {
            be.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.f_46443_) {
                level.m_7654_().m_6846_().m_11268_((Packet)be.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player);
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)action;
            Option option = optionChanged.option();
            for (Option option2 : this.customOptions()) {
                if (!option2.getName().equals(option.getName())) continue;
                option2.copy(option);
                break;
            }
            this.m_6596_();
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack(), moduleInserted.wasModuleToggled());
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType(), moduleRemoved.wasModuleToggled());
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public abstract int defaultSignalLength();
}

