/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class UsernameLoggerBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable {
    private static final int TICKS_BETWEEN_ATTACKS = 80;
    private Option.IntOption searchRadius = new Option.IntOption("searchRadius", 3, 1, 20, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private String[] players = new String[100];
    private String[] uuids = new String[100];
    private long[] timestamps = new long[100];
    private int cooldown = 80;

    public UsernameLoggerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.isDisabled()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (level.m_277086_(pos) > 0) {
            level.m_6443_(Player.class, new AABB(pos).m_82400_((double)((Integer)this.searchRadius.get()).intValue()), e -> !e.m_5833_()).forEach(this::addPlayer);
            this.syncLoggedPlayersToClient();
            this.cooldown = 80;
        }
    }

    public void addPlayer(Player player) {
        String playerName = player.m_7755_().getString();
        long timestamp = System.currentTimeMillis();
        if (!(this.isOwnedBy(player) && this.ignoresOwner() || EntityUtils.isInvisible((LivingEntity)player) || this.wasPlayerRecentlyAdded(playerName, timestamp))) {
            if (this.isAllowed((Entity)player)) {
                return;
            }
            for (int i = 0; i < this.getPlayers().length; ++i) {
                if (this.getPlayers()[i] != null && !this.getPlayers()[i].equals("")) continue;
                this.getPlayers()[i] = player.m_7755_().getString();
                this.getUuids()[i] = player.m_36316_().getId().toString();
                this.getTimestamps()[i] = timestamp;
                this.m_6596_();
                break;
            }
        }
    }

    private boolean wasPlayerRecentlyAdded(String username, long timestamp) {
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null || !this.getPlayers()[i].equals(username) || this.getTimestamps()[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            tag.m_128359_("player" + i, this.getPlayers()[i] == null ? "" : this.getPlayers()[i]);
            tag.m_128359_("uuid" + i, this.getUuids()[i] == null ? "" : this.getUuids()[i]);
            tag.m_128356_("timestamp" + i, this.getTimestamps()[i]);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        for (int i = 0; i < this.getPlayers().length; ++i) {
            this.getPlayers()[i] = tag.m_128461_("player" + i);
            this.getUuids()[i] = tag.m_128461_("uuid" + i);
            this.getTimestamps()[i] = tag.m_128454_("timestamp" + i);
        }
    }

    public void syncLoggedPlayersToClient() {
        for (int i = 0; i < this.getPlayers().length; ++i) {
            if (this.getPlayers()[i] == null) continue;
            SecurityCraft.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new UpdateLogger(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), i, this.getPlayers()[i], this.getUuids()[i], this.getTimestamps()[i]));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius, this.disabled, this.ignoreOwner};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public String[] getPlayers() {
        return this.players;
    }

    public void setPlayers(String[] players) {
        this.players = players;
    }

    public String[] getUuids() {
        return this.uuids;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }
}

