/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.BiConsumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class KeycardReaderBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KeycardReaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return KeycardReaderBlock.use(state, level, pos, player, hand, (stack, be) -> {
            if (be.isOwnedBy(player) || be.isAllowed((Entity)player)) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
            }
        });
    }

    public static <BE extends KeycardReaderBlockEntity> InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BiConsumer<ItemStack, BE> noKeycardRightclick) {
        if (!level.f_46443_) {
            KeycardReaderBlockEntity be = (KeycardReaderBlockEntity)level.m_7702_(pos);
            if (be.isDisabled()) {
                player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.isDenied((Entity)player)) {
                if (be.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)state.m_60734_().m_7705_()), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else {
                boolean isKeycardHolder;
                ItemStack stack = player.m_21120_(hand);
                Item item = stack.m_41720_();
                boolean isCodebreaker = item == SCContent.CODEBREAKER.get();
                boolean bl = isKeycardHolder = item == SCContent.KEYCARD_HOLDER.get();
                if (!(isKeycardHolder || item instanceof KeycardItem && stack.m_41782_() && stack.m_41783_().m_128471_("linked") || isCodebreaker)) {
                    noKeycardRightclick.accept(stack, be);
                } else if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    return be.onRightClickWithActionItem(stack, hand, player, isCodebreaker, isKeycardHolder);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)SCContent.KEYCARD_READER.get());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            level.m_46672_(pos, (Block)this);
            BlockUtils.updateIndirectNeighbors(level, pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.m_123341_() + 0.5f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double y = (double)((float)pos.m_123342_() + 0.7f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double z = (double)((float)pos.m_123343_() + 0.5f) + (double)(rand.m_188501_() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float r = 1.0f;
            float g = Math.max(0.0f, 0.19999999f);
            float b = Math.max(0.0f, -0.099999964f);
            Vector3f vec = new Vector3f(r, g, b);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            level.m_6493_((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_43723_().m_6350_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeycardReaderBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

