/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadBarrelBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;

public class KeypadBarrelBlock
extends DisguisableBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<LidFacing> LID_FACING = EnumProperty.m_61587_((String)"lid_facing", LidFacing.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty FROG = BooleanProperty.m_61465_((String)"frog");

    public KeypadBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(LID_FACING, (Comparable)((Object)LidFacing.UP))).m_61124_((Property)FROG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(LID_FACING, (Comparable)((Object)LidFacing.fromDirection(ctx.m_7820_().m_122424_())));
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof KeypadBarrelBlockEntity) {
            KeypadBarrelBlockEntity barrel = (KeypadBarrelBlockEntity)blockEntity;
            barrel.m_58638_(stack.m_41786_());
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            KeypadBarrelBlockEntity be = (KeypadBarrelBlockEntity)level.m_7702_(pos);
            if (player.m_21120_(hand).m_150930_(Items.f_220213_) && be.isOwnedBy(player)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)FROG));
                return InteractionResult.SUCCESS;
            }
            if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, player);
                } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider menuProvider;
        if (!level.f_46443_ && (menuProvider = this.m_7246_(state, level, pos)) != null) {
            player.m_5893_(menuProvider);
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12971_));
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof Container) {
                Container container = (Container)be;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KeypadBarrelBlockEntity) {
            KeypadBarrelBlockEntity barrel = (KeypadBarrelBlockEntity)blockEntity;
            barrel.recheckOpen();
        }
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadBarrelBlockEntity(pos, state);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, LID_FACING, OPEN, FROG, WATERLOGGED});
    }

    public static enum LidFacing implements StringRepresentable
    {
        UP("up"),
        SIDEWAYS("sideways"),
        DOWN("down");

        private final String name;

        private LidFacing(String name) {
            this.name = name;
        }

        public static LidFacing fromDirection(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> UP;
                case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> SIDEWAYS;
                case Direction.DOWN -> DOWN;
            };
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isValidStateForConversion(BlockState state) {
            return state.m_204336_(Tags.Blocks.BARRELS_WOODEN);
        }

        @Override
        public boolean convert(Player player, Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            BarrelBlockEntity barrel = (BarrelBlockEntity)level.m_7702_(pos);
            LidFacing generalFacing = LidFacing.fromDirection((Direction)state.m_61143_((Property)BarrelBlock.f_49042_));
            barrel.m_59640_(player);
            CompoundTag tag = barrel.m_187480_();
            barrel.m_6211_();
            Direction horizontalFacing = switch (generalFacing) {
                default -> throw new IncompatibleClassChangeError();
                case LidFacing.UP, LidFacing.DOWN -> player.m_6350_().m_122424_();
                case LidFacing.SIDEWAYS -> (Direction)state.m_61143_((Property)BarrelBlock.f_49042_);
            };
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((Block)SCContent.KEYPAD_BARREL.get()).m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)horizontalFacing)).m_61124_(LID_FACING, (Comparable)((Object)generalFacing))).m_61124_((Property)OPEN, (Comparable)((Boolean)state.m_61143_((Property)BarrelBlock.f_49043_))));
            KeypadBarrelBlockEntity keypadBarrel = (KeypadBarrelBlockEntity)level.m_7702_(pos);
            keypadBarrel.m_142466_(tag);
            keypadBarrel.setOwner(player.m_20148_().toString(), player.m_7755_().getString());
            return true;
        }
    }
}

