/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.awt.Rectangle;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.compat.waila.WailaCompatConstants;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public final class WTHITDataProvider
extends WailaCompatConstants
implements IWailaPlugin,
IBlockComponentProvider,
IEntityComponentProvider,
IEventListener {
    public static final WTHITDataProvider INSTANCE = new WTHITDataProvider();

    public void register(IRegistrar registrar) {
        registrar.addEventListener((IEventListener)INSTANCE);
        registrar.addSyncedConfig(SHOW_OWNER, true, true);
        registrar.addSyncedConfig(SHOW_MODULES, true, true);
        registrar.addSyncedConfig(SHOW_CUSTOM_NAME, true, true);
        registrar.addComponent((IBlockComponentProvider)INSTANCE, TooltipPosition.HEAD, IOverlayDisplay.class);
        registrar.addComponent((IBlockComponentProvider)INSTANCE, TooltipPosition.BODY, IOwnable.class);
        registrar.addComponent((IBlockComponentProvider)INSTANCE, TooltipPosition.TAIL, IOverlayDisplay.class);
        registrar.addIcon((IBlockComponentProvider)INSTANCE, IOverlayDisplay.class);
        registrar.addComponent((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, Sentry.class);
    }

    public ITooltipComponent getIcon(IBlockAccessor data, IPluginConfig config) {
        ItemStack displayStack = ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        if (displayStack != null) {
            return new ItemComponent(displayStack);
        }
        return super.getIcon(data, config);
    }

    public void appendHead(ITooltip tooltip, IBlockAccessor data, IPluginConfig config) {
        ItemStack displayStack = ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition());
        if (displayStack != null) {
            tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, (Component)Component.m_237115_((String)displayStack.m_41778_()).m_6270_(ITEM_NAME_STYLE));
        }
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor data, IPluginConfig config) {
        Nameable nameable;
        IOverlayDisplay overlayDisplay;
        Optional<BlockState> disguisedBlockState;
        Block block = data.getBlock();
        boolean disguised = false;
        if (block instanceof DisguisableBlock && (disguisedBlockState = DisguisableBlock.getDisguisedBlockState((LevelReader)data.getWorld(), data.getPosition())).isPresent()) {
            disguised = true;
            block = disguisedBlockState.get().m_60734_();
        }
        if (block instanceof IOverlayDisplay && !(overlayDisplay = (IOverlayDisplay)block).shouldShowSCInfo(data.getWorld(), data.getBlockState(), data.getPosition())) {
            return;
        }
        BlockEntity be = data.getBlockEntity();
        if (config.getBoolean(SHOW_OWNER) && be instanceof IOwnable) {
            IOwnable ownable = (IOwnable)be;
            if (Utils.getRegistryName(block).m_135827_().equals("securitycraft")) {
                tooltip.addLine((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner())));
            }
        }
        if (disguised) {
            return;
        }
        if (config.getBoolean(SHOW_MODULES) && be instanceof IModuleInventory) {
            IOwnable ownable;
            IModuleInventory moduleInv = (IModuleInventory)be;
            if (!(be instanceof IOwnable) || (ownable = (IOwnable)be).isOwnedBy(data.getPlayer())) {
                if (!moduleInv.getInsertedModules().isEmpty()) {
                    tooltip.addLine((Component)Utils.localize("waila.securitycraft:equipped", new Object[0]));
                }
                for (ModuleType module : moduleInv.getInsertedModules()) {
                    tooltip.addLine((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)module.getTranslationKey())));
                }
            }
        }
        if (config.getBoolean(SHOW_CUSTOM_NAME) && be instanceof Nameable && (nameable = (Nameable)be).m_8077_()) {
            Component text = nameable.m_7770_();
            MutableComponent name = text == null ? Component.m_237119_() : text;
            tooltip.addLine((Component)Utils.localize("waila.securitycraft:customName", name));
        }
    }

    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        ItemStack disguisedAs = ((IOverlayDisplay)accessor.getBlock()).getDisplayStack(accessor.getWorld(), accessor.getBlockState(), accessor.getPosition());
        if (disguisedAs != null) {
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, (Component)Component.m_237113_((String)((ModContainer)ModList.get().getModContainerById(Utils.getRegistryName(disguisedAs.m_41720_()).m_135827_()).get()).getModInfo().getDisplayName()).m_6270_(MOD_NAME_STYLE));
        }
    }

    public void appendBody(ITooltip tooltip, IEntityAccessor data, IPluginConfig config) {
        Entity entity = data.getEntity();
        if (entity instanceof Sentry) {
            Sentry sentry = (Sentry)entity;
            Sentry.SentryMode mode = sentry.getMode();
            if (config.getBoolean(SHOW_OWNER)) {
                tooltip.addLine((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner())));
            }
            if (config.getBoolean(SHOW_MODULES) && sentry.isOwnedBy(data.getPlayer()) && (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule())) {
                tooltip.addLine((Component)EQUIPPED);
                if (!sentry.getAllowlistModule().m_41619_()) {
                    tooltip.addLine((Component)ALLOWLIST_MODULE);
                }
                if (!sentry.getDisguiseModule().m_41619_()) {
                    tooltip.addLine((Component)DISGUISE_MODULE);
                }
                if (sentry.hasSpeedModule()) {
                    tooltip.addLine((Component)SPEED_MODULE);
                }
            }
            MutableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            tooltip.addLine((Component)modeDescription);
        }
    }

    public void onBeforeTooltipRender(GuiGraphics guiGraphics, Rectangle rectangle, ICommonAccessor accessor, IPluginConfig config, IEventListener.Canceller canceller) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            canceller.cancel();
        }
    }
}

