/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import com.google.common.collect.Sets;
import java.util.Collection;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class Bullet
extends AbstractArrow {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.m_135353_(Bullet.class, Owner.getSerializer());
    private Collection<MobEffectInstance> potionEffects = Sets.newHashSet();

    public Bullet(EntityType<Bullet> type, Level level) {
        super((EntityType)SCContent.BULLET_ENTITY.get(), level);
    }

    public Bullet(Level level, Sentry shooter) {
        super((EntityType)SCContent.BULLET_ENTITY.get(), (LivingEntity)shooter, level);
        Owner owner = shooter.getOwner();
        this.potionEffects = shooter.m_21220_();
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(owner.getName(), owner.getUUID()));
    }

    public Owner getSCOwner() {
        return (Owner)this.f_19804_.m_135370_(OWNER);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, (Object)new Owner());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.potionEffects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance effect : this.potionEffects) {
                list.add((Object)effect.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("PotionEffects", (Tag)list);
        }
    }

    public void m_7378_(CompoundTag tag) {
        ListTag potionList;
        super.m_7378_(tag);
        if (tag.m_128425_("PotionEffects", 9) && !(potionList = tag.m_128437_("PotionEffects", 10)).isEmpty()) {
            for (int i = 0; i < potionList.size(); ++i) {
                MobEffectInstance effect = MobEffectInstance.m_19560_((CompoundTag)potionList.m_128728_(i));
                if (effect == null) continue;
                this.potionEffects.add(effect);
            }
        }
    }

    protected void m_5790_(EntityHitResult raytraceResult) {
        Entity target = raytraceResult.m_82443_();
        if (!(target instanceof Sentry) && !(target instanceof ItemFrame)) {
            target.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_()), (float)Mth.m_14165_((double)this.m_20184_().m_82553_()));
            if (target instanceof LivingEntity) {
                LivingEntity lEntity = (LivingEntity)target;
                if (!this.potionEffects.isEmpty()) {
                    for (MobEffectInstance effect : this.potionEffects) {
                        lEntity.m_7292_(effect);
                    }
                }
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(BlockHitResult raytraceResult) {
        this.m_146870_();
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

