/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class SentryRemoteAccessToolItem
extends Item {
    public SentryRemoteAccessToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL));
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        List sentries = level.m_45976_(Sentry.class, new AABB(pos));
        if (!sentries.isEmpty()) {
            Sentry sentry;
            BlockPos sentryPos;
            ItemStack stack = ctx.m_43722_();
            if (!SentryRemoteAccessToolItem.isSentryAdded(stack, sentryPos = (sentry = (Sentry)sentries.get(0)).m_20183_())) {
                int availSlot = SentryRemoteAccessToolItem.getNextAvailableSlot(stack);
                if (availSlot == 0) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:srat.noSlots", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (!sentry.isOwnedBy(player)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:srat.cantBind", new Object[0]), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128385_("sentry" + availSlot, BlockUtils.posToIntArray(sentryPos));
                if (!level.f_46443_ && !stack.m_41619_()) {
                    SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:srat.bound", sentryPos), ChatFormatting.GREEN);
            } else {
                this.removeTagFromItemAndUpdate(stack, sentryPos, player);
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:srat.unbound", sentryPos), ChatFormatting.RED);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.f_46443_) {
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SENTRY_REMOTE_ACCESS_TOOL));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.m_41783_().m_128465_("sentry" + i);
            if (coords.length != 3) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "---")));
                continue;
            }
            BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
            List sentries = Minecraft.m_91087_().f_91074_.m_9236_().m_45976_(Sentry.class, new AABB(pos));
            Object nameToShow = !sentries.isEmpty() && ((Sentry)sentries.get(0)).m_8077_() ? ((Sentry)sentries.get(0)).m_7770_().getString() : Utils.localize("tooltip.securitycraft:sentry", new Object[0]).getString() + " " + i;
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + (String)nameToShow + ": " + Utils.getFormattedCoordinates(pos).getString())));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, Player player) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.m_41783_().m_128465_("sentry" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128473_("sentry" + i);
            if (!player.m_9236_().f_46443_ && !stack.m_41619_()) {
                SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateNBTTagOnClient(stack));
            }
            return;
        }
    }

    public static boolean hasSentryAdded(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            if (!tag.m_128441_("sentry" + i)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.m_41783_().m_128465_("sentry" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    public static int getNextAvailableSlot(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 1;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.m_41783_().m_128465_("sentry" + i).length == 3) continue;
            return i;
        }
        return 0;
    }
}

