/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class UniversalBlockReinforcerItem
extends Item {
    public UniversalBlockReinforcerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_) {
            UniversalBlockReinforcerItem.maybeRemoveMending(heldItem);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                    return new BlockReinforcerMenu(windowId, inv, UniversalBlockReinforcerItem.this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
                }

                public Component m_5446_() {
                    return Component.m_237115_((String)UniversalBlockReinforcerItem.this.m_5524_());
                }
            }, data -> data.writeBoolean(this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()));
        }
        return InteractionResultHolder.m_19096_((Object)heldItem);
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player) {
        if (!player.m_7500_()) {
            boolean isReinforcing = UniversalBlockReinforcerItem.isReinforcing(stack);
            Block block = state.m_60734_();
            Block convertedBlock = (isReinforcing ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).get(block);
            BlockState convertedState = null;
            if (isReinforcing && convertedBlock instanceof IReinforcedBlock) {
                IReinforcedBlock rb = (IReinforcedBlock)convertedBlock;
                convertedState = rb.convertToReinforced(level, pos, state);
            } else if (!isReinforcing && block instanceof IReinforcedBlock) {
                IReinforcedBlock rb = (IReinforcedBlock)block;
                convertedState = rb.convertToVanilla(level, pos, state);
            }
            if (convertedState != null) {
                IOwnable ownable;
                BlockEntity be = level.m_7702_(pos);
                CompoundTag tag = null;
                if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy(player)) {
                    return false;
                }
                if (be != null) {
                    tag = be.m_187482_();
                    if (be instanceof Container) {
                        Container container = (Container)be;
                        container.m_6211_();
                    }
                }
                level.m_46597_(pos, convertedState);
                be = level.m_7702_(pos);
                if (be != null) {
                    if (tag != null) {
                        be.m_142466_(tag);
                    }
                    if (isReinforcing) {
                        ((IOwnable)be).setOwner(player.m_36316_().getId().toString(), player.m_7755_().getString());
                    }
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                return false;
            }
        }
        return true;
    }

    public static boolean isReinforcing(ItemStack stack) {
        return stack.m_150930_((Item)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()) || !stack.m_41784_().m_128471_("is_unreinforcing");
    }

    public static void maybeRemoveMending(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (enchantments.containsKey(Enchantments.f_44962_)) {
            enchantments.remove(Enchantments.f_44962_);
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.m_44831_((ItemStack)book).containsKey(Enchantments.f_44962_);
    }
}

