/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class OverlayToggleHandler {
    private static final Map<IGuiOverlay, Boolean> OVERLAY_STATES = new HashMap<IGuiOverlay, Boolean>();

    private OverlayToggleHandler() {
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        IGuiOverlay overlay = event.getOverlay().overlay();
        if (OVERLAY_STATES.containsKey(overlay) && !OverlayToggleHandler.isEnabled(overlay)) {
            event.setCanceled(true);
        }
    }

    public static boolean isEnabled(VanillaGuiOverlay overlay) {
        return OverlayToggleHandler.isEnabled(GuiOverlayManager.findOverlay((ResourceLocation)overlay.id()).overlay());
    }

    public static boolean isEnabled(NamedGuiOverlay overlay) {
        return OverlayToggleHandler.isEnabled(overlay.overlay());
    }

    public static boolean isEnabled(IGuiOverlay overlay) {
        return OVERLAY_STATES.get(overlay);
    }

    public static void enable(VanillaGuiOverlay overlay) {
        OverlayToggleHandler.enable(overlay.type().overlay());
    }

    public static void enable(NamedGuiOverlay overlay) {
        OverlayToggleHandler.enable(overlay.overlay());
    }

    public static void enable(IGuiOverlay overlay) {
        OVERLAY_STATES.put(overlay, true);
    }

    public static void disable(VanillaGuiOverlay overlay) {
        OverlayToggleHandler.disable(overlay.type().overlay());
    }

    public static void disable(NamedGuiOverlay overlay) {
        OverlayToggleHandler.disable(overlay.overlay());
    }

    public static void disable(IGuiOverlay overlay) {
        OVERLAY_STATES.put(overlay, false);
    }
}

