/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class OpenScreen {
    private DataType dataType;
    private BlockPos pos;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType) {
        this.dataType = dataType;
        if (dataType.needsPosition) {
            throw new IllegalArgumentException(String.format("The DataType %s needs a position, but none was supplied.", dataType.name()));
        }
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public OpenScreen(FriendlyByteBuf buf) {
        this.dataType = (DataType)buf.m_130066_(DataType.class);
        if (this.dataType.needsPosition) {
            this.pos = buf.m_130135_();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.dataType);
        if (this.dataType.needsPosition) {
            buf.m_130064_(this.pos);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        switch (this.dataType) {
            case ALARM: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof AlarmBlockEntity)) break;
                AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
                ClientHandler.displayAlarmScreen(be);
                break;
            }
            case CHECK_BRIEFCASE_PASSCODE: {
                ItemStack briefcaseStack = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcaseStack.m_41619_()) break;
                ClientHandler.displayBriefcasePasscodeScreen(briefcaseStack.m_41786_());
                break;
            }
            case CHECK_PASSCODE: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayCheckPasscodeScreen((BlockEntity)be);
                break;
            }
            case IMS: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof IMSBlockEntity)) break;
                IMSBlockEntity ims = (IMSBlockEntity)blockEntity;
                ClientHandler.displayIMSScreen(ims);
                break;
            }
            case RIFT_STABILIZER: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof RiftStabilizerBlockEntity)) break;
                RiftStabilizerBlockEntity riftStabilizer = (RiftStabilizerBlockEntity)blockEntity;
                ClientHandler.displayRiftStabilizerScreen(riftStabilizer);
                break;
            }
            case SENTRY_REMOTE_ACCESS_TOOL: {
                ItemStack srat = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
                if (srat.m_41619_()) break;
                ClientHandler.displaySRATScreen(srat);
                break;
            }
            case SET_BRIEFCASE_PASSCODE: {
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcase.m_41619_()) break;
                ClientHandler.displayBriefcaseSetupScreen((Component)briefcase.m_41786_().m_6879_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Utils.localize("gui.securitycraft:passcode.setup", new Object[0])));
                break;
            }
            case SET_PASSCODE: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displaySetPasscodeScreen((BlockEntity)be);
                break;
            }
            case SONIC_SECURITY_SYSTEM: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof SonicSecuritySystemBlockEntity)) break;
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)blockEntity;
                ClientHandler.displaySonicSecuritySystemScreen(sss);
                break;
            }
            case UNIVERSAL_KEY_CHANGER: {
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)blockEntity;
                ClientHandler.displayUniversalKeyChangerScreen((BlockEntity)passcodeProtected);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data type: " + this.dataType.name());
            }
        }
    }

    public static enum DataType {
        ALARM(true),
        CHECK_BRIEFCASE_PASSCODE(false),
        CHECK_PASSCODE(true),
        IMS(true),
        RIFT_STABILIZER(true),
        SENTRY_REMOTE_ACCESS_TOOL(false),
        SET_BRIEFCASE_PASSCODE(false),
        SET_PASSCODE(true),
        SONIC_SECURITY_SYSTEM(true),
        UNIVERSAL_KEY_CHANGER(true);

        public final boolean needsPosition;

        private DataType(boolean needsPosition) {
            this.needsPosition = needsPosition;
        }
    }
}

