/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class MountCamera {
    private BlockPos pos;

    public MountCamera() {
    }

    public MountCamera(BlockPos pos) {
        this.pos = pos;
    }

    public MountCamera(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        BlockState state = level.m_8055_(this.pos);
        if (level.m_46749_(this.pos) && state.m_60734_() == SCContent.SECURITY_CAMERA.get() && (blockEntity = level.m_7702_(this.pos)) instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            if (be.isOwnedBy((Player)player) || be.isAllowed((Entity)player)) {
                ((SecurityCameraBlock)state.m_60734_()).mountCamera(level, this.pos, (Player)player);
            } else {
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", be.getOwner().getName()), ChatFormatting.RED);
            }
        } else {
            PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((Item)SCContent.CAMERA_MONITOR.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cameraNotAvailable", this.pos), ChatFormatting.RED);
        }
    }
}

