/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncBlockChangeDetector {
    private BlockPos pos;
    private BlockChangeDetectorBlockEntity.DetectionMode mode;
    private boolean showHighlights;
    private int color;

    public SyncBlockChangeDetector() {
    }

    public SyncBlockChangeDetector(BlockPos pos, BlockChangeDetectorBlockEntity.DetectionMode mode, boolean showHighlights, int color) {
        this.pos = pos;
        this.mode = mode;
        this.showHighlights = showHighlights;
        this.color = color;
    }

    public SyncBlockChangeDetector(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.mode = (BlockChangeDetectorBlockEntity.DetectionMode)buf.m_130066_(BlockChangeDetectorBlockEntity.DetectionMode.class);
        this.showHighlights = buf.readBoolean();
        this.color = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130068_((Enum)this.mode);
        buf.writeBoolean(this.showHighlights);
        buf.writeInt(this.color);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockChangeDetectorBlockEntity be;
        Level level = ctx.get().getSender().m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof BlockChangeDetectorBlockEntity && (be = (BlockChangeDetectorBlockEntity)blockEntity).isOwnedBy((Player)ctx.get().getSender())) {
            BlockState state = level.m_8055_(this.pos);
            be.setMode(this.mode);
            be.showHighlights(this.showHighlights);
            be.setColor(this.color);
            be.m_6596_();
            level.m_7260_(this.pos, state, state, 2);
        }
    }
}

