/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncBlockPocketManager {
    private BlockPos pos;
    private int size;
    private boolean showOutline;
    private int autoBuildOffset;
    private int color;

    public SyncBlockPocketManager() {
    }

    public SyncBlockPocketManager(BlockPos pos, int size, boolean showOutline, int autoBuildOffset, int color) {
        this.pos = pos;
        this.size = size;
        this.showOutline = showOutline;
        this.autoBuildOffset = autoBuildOffset;
        this.color = color;
    }

    public SyncBlockPocketManager(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.size = buf.m_130242_();
        this.showOutline = buf.readBoolean();
        this.autoBuildOffset = buf.m_130242_();
        this.color = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.size);
        buf.writeBoolean(this.showOutline);
        buf.m_130130_(this.autoBuildOffset);
        buf.writeInt(this.color);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockPocketManagerBlockEntity bpm;
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        if (level.m_46749_(this.pos) && (blockEntity = level.m_7702_(this.pos)) instanceof BlockPocketManagerBlockEntity && (bpm = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Player)player)) {
            BlockState state = level.m_8055_(this.pos);
            bpm.setSize(this.size);
            bpm.setShowOutline(this.showOutline);
            bpm.setAutoBuildOffset(this.autoBuildOffset);
            bpm.setColor(this.color);
            bpm.m_6596_();
            level.m_7260_(this.pos, state, state, 2);
        }
    }
}

