/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.SmallXButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final Component selectCameras = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]);
    private Inventory playerInventory;
    private CameraMonitorItem cameraMonitor;
    private CompoundTag nbtTag;
    private Button[] cameraButtons = new Button[10];
    private Button[] unbindButtons = new Button[10];
    private CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int xSize = 176;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private int page = 1;

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag) {
        super((Component)Component.m_237115_((String)((Item)SCContent.CAMERA_MONITOR.get()).m_5524_()));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(Inventory inventory, CameraMonitorItem item, CompoundTag itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void m_7856_() {
        int i;
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.xSize) / 2;
        this.topPos = (this.f_96544_ - this.ySize) / 2;
        Button prevPageButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 25, this.f_96544_ / 2 + 57, 20, 20, (Component)Component.m_237113_((String)"<"), b -> this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1)), Button.f_252438_));
        Button nextPageButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 57, 20, 20, (Component)Component.m_237113_((String)">"), b -> this.f_96541_.m_91152_((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1)), Button.f_252438_));
        List<GlobalPos> views = CameraMonitorItem.getCameraPositions(this.nbtTag);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.leftPos + 18 + i % 5 * 30;
            int y = this.topPos + 30 + i / 5 * 55;
            Button cameraButton = (Button)this.m_142416_((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.m_237119_(), button -> this.cameraButtonClicked(button, buttonId), Button.f_252438_));
            Button unbindButton = (Button)this.m_142416_((GuiEventListener)new SmallXButton(x + 19, y - 8, button -> this.unbindButtonClicked(button, buttonId)));
            GlobalPos view = views.get(camID - 1);
            this.cameraButtons[i] = cameraButton;
            this.unbindButtons[i] = unbindButton;
            cameraButton.m_93666_((Component)cameraButton.m_6035_().m_6879_().m_7220_((Component)Component.m_237113_((String)("" + camID))));
            if (view != null) {
                SecurityCameraBlockEntity camera;
                SecurityCameraBlockEntity cameraBe;
                BlockEntity blockEntity = level.m_7702_(view.m_122646_());
                SecurityCameraBlockEntity securityCameraBlockEntity = cameraBe = blockEntity instanceof SecurityCameraBlockEntity ? (camera = (SecurityCameraBlockEntity)blockEntity) : null;
                if (cameraBe == null) continue;
                BlockState state = level.m_8055_(view.m_122646_());
                if (cameraBe.isDisabled()) {
                    cameraButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
                    cameraButton.f_93623_ = false;
                } else if (cameraBe.m_8077_()) {
                    cameraButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:monitor.cameraName", cameraBe.m_7770_())));
                }
                if (state.m_60746_((BlockGetter)level, view.m_122646_(), (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0) {
                    if (!cameraBe.isModuleEnabled(ModuleType.REDSTONE)) {
                        this.redstoneModuleStates[i] = CameraRedstoneModuleState.NOT_INSTALLED;
                        continue;
                    }
                    this.redstoneModuleStates[i] = CameraRedstoneModuleState.DEACTIVATED;
                    continue;
                }
                this.redstoneModuleStates[i] = CameraRedstoneModuleState.ACTIVATED;
                continue;
            }
            cameraButton.f_93623_ = false;
            unbindButton.f_93623_ = false;
        }
        if (this.page == 1) {
            prevPageButton.f_93623_ = false;
        }
        if (this.page == 3 || CameraMonitorItem.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            nextPageButton.f_93623_ = false;
        }
        for (i = CameraMonitorItem.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].f_93623_ = false;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 10; ++i) {
            Button button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render(guiGraphics, button.m_252754_() + 4, button.m_252907_() + 25);
        }
        guiGraphics.m_280614_(this.f_96547_, this.selectCameras, this.leftPos + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.selectCameras) / 2, this.topPos + 6, 0x404040, false);
    }

    private void cameraButtonClicked(Button button, int buttonId) {
        SecurityCameraBlockEntity camera;
        int camID = buttonId + (this.page - 1) * 10;
        BlockPos cameraPos = CameraMonitorItem.getCameraPositions(this.nbtTag).get(camID - 1).m_122646_();
        BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(cameraPos);
        if (blockEntity instanceof SecurityCameraBlockEntity && (camera = (SecurityCameraBlockEntity)blockEntity).isDisabled()) {
            button.f_93623_ = false;
            return;
        }
        SecurityCraft.CHANNEL.sendToServer((Object)new MountCamera(cameraPos));
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    private void unbindButtonClicked(Button button, int buttonId) {
        int camID = buttonId + (this.page - 1) * 10;
        int i = (camID - 1) % 10;
        Button cameraButton = this.cameraButtons[i];
        SecurityCraft.CHANNEL.sendToServer((Object)new RemoveCameraTag(camID));
        this.nbtTag.m_128473_(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, CameraMonitorItem.getCameraPositions(this.nbtTag).get(camID - 1)));
        button.f_93623_ = false;
        cameraButton.f_93623_ = false;
        cameraButton.m_257544_(null);
        this.redstoneModuleStates[i] = null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }
}

