/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class InventoryScannerScreen
extends AbstractContainerScreen<InventoryScannerMenu> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    public final InventoryScannerBlockEntity be;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private Component infoStringRedstone;
    private Component infoStringStorage;
    private static final Style UNDERLINE = Style.f_131099_.m_131157_(ChatFormatting.UNDERLINE);
    private final Component prohibitedItems = Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]);
    private final Component adminMode = Utils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]).m_6270_(UNDERLINE);
    private final Component viewMode = Utils.localize("gui.securitycraft:invScan.mode.view", new Object[0]).m_6270_(UNDERLINE);
    private final Component storage = Utils.localize("gui.securitycraft:invScan.storage", new Object[0]);
    private Component redstoneModuleTooltip = null;
    private Component storageModuleTooltip = null;

    public InventoryScannerScreen(InventoryScannerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.owns = this.be.isOwnedBy(inv.f_35978_);
        this.hasRedstoneModule = this.be.isModuleEnabled(ModuleType.REDSTONE);
        this.hasStorageModule = this.be.isModuleEnabled(ModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0]));
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        if (!this.hasRedstoneModule) {
            this.redstoneModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.REDSTONE_MODULE.get())).m_5524_(), new Object[0]));
        }
        if (this.hasStorageModule) {
            this.f_97726_ = 246;
        } else {
            this.f_97726_ = 190;
            this.storageModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.STORAGE_MODULE.get())).m_5524_(), new Object[0]));
        }
        this.f_97727_ = 196;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)this.infoStringRedstone, this.f_97735_ + 28, this.f_97736_ + 45, 150, 0x404040);
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)this.infoStringStorage, this.f_97735_ + 28, this.f_97736_ + 75, 150, 0x404040);
        ClientUtils.renderModuleInfo(guiGraphics, this.f_96547_, ModuleType.REDSTONE, this.redstoneModuleTooltip, this.hasRedstoneModule, this.f_97735_ + 8, this.f_97736_ + 45, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.f_96547_, ModuleType.STORAGE, this.storageModuleTooltip, this.hasStorageModule, this.f_97735_ + 8, this.f_97736_ + 75, mouseX, mouseY);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.prohibitedItems, 8, 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.be.isOwnedBy((Player)this.f_96541_.f_91074_) ? this.adminMode : this.viewMode, 112, 6, 0x404040, false);
        if (this.hasStorageModule && this.owns) {
            guiGraphics.m_280614_(this.f_96547_, this.storage, 188, 18, 0x404040, false);
        }
        guiGraphics.m_280614_(this.f_96547_, Utils.INVENTORY_TEXT, 15, this.f_97727_ - 93, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : REGULAR_INVENTORY, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_ + 30);
    }
}

