/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.screen.components.SmallXButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class UsernameLoggerScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final Component logged = Utils.localize("gui.securitycraft:logger.logged", new Object[0]);
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private UsernameLoggerBlockEntity be;
    private PlayerList playerList;

    public UsernameLoggerScreen(UsernameLoggerBlockEntity be) {
        super(be.m_5446_());
        this.be = be;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        Button clearButton = (Button)this.m_142416_((GuiEventListener)new SmallXButton(this.leftPos + 4, this.topPos + 4, b -> {
            this.be.setPlayers(new String[100]);
            SecurityCraft.CHANNEL.sendToServer((Object)new ClearLoggerServer(this.be.m_58899_()));
        }));
        clearButton.f_93623_ = this.be.isOwnedBy((Player)this.f_96541_.f_91074_);
        clearButton.m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0])));
        this.playerList = (PlayerList)this.m_142416_((GuiEventListener)new PlayerList(this.f_96541_, this.imageWidth - 24, this.imageHeight - 40, this.topPos + 20, this.leftPos + 12));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, this.logged, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.logged) / 2, this.topPos + 6, 0x404040, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.playerList != null) {
            this.playerList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    class PlayerList
    extends ScrollPanel {
        private final DateFormat dateFormat;
        private static final int SLOT_HEIGHT = 12;
        private static final int LIST_LENGTH = 100;

        public PlayerList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        }

        protected int getContentHeight() {
            int n = UsernameLoggerScreen.this.be.getPlayers().length;
            Objects.requireNonNull(UsernameLoggerScreen.this.f_96547_);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (UsernameLoggerScreen.this.be.isOwnedBy((Player)((UsernameLoggerScreen)UsernameLoggerScreen.this).f_96541_.f_91074_)) {
                String[] players;
                int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
                int slotIndex = mouseListY / 12;
                if (mouseX >= this.left && mouseX < this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 100 && mouseY >= this.top && mouseY <= this.bottom && (players = UsernameLoggerScreen.this.be.getPlayers())[slotIndex] != null && !players[slotIndex].isEmpty()) {
                    MutableComponent localized = Utils.localize("gui.securitycraft:logger.date", this.dateFormat.format(new Date(UsernameLoggerScreen.this.be.getTimestamps()[slotIndex])));
                    String[] uuids = UsernameLoggerScreen.this.be.getUuids();
                    if (uuids[slotIndex] != null && !uuids[slotIndex].isEmpty()) {
                        guiGraphics.m_280557_(UsernameLoggerScreen.this.f_96547_, (Component)Component.m_237113_((String)UsernameLoggerScreen.this.be.getUuids()[slotIndex]), mouseX, mouseY);
                    }
                    guiGraphics.m_280614_(UsernameLoggerScreen.this.f_96547_, (Component)localized, UsernameLoggerScreen.this.leftPos + (UsernameLoggerScreen.this.imageWidth / 2 - UsernameLoggerScreen.this.f_96547_.m_92852_((FormattedText)localized) / 2), this.bottom + 5, 0x404040, false);
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            String[] players;
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)this.border);
            int slotIndex = mouseListY / 12;
            if (mouseX >= this.left && mouseX <= this.right - 6 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < 100 && mouseY >= this.top && mouseY <= this.bottom && (players = UsernameLoggerScreen.this.be.getPlayers())[slotIndex] != null && !players[slotIndex].isEmpty()) {
                int min = this.left;
                int max = entryRight - 6;
                int slotTop = baseY + slotIndex * 12;
                BufferBuilder bufferBuilder = tess.m_85915_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_5483_((double)min, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop + slotBuffer + 2), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)max, (double)(slotTop - 2), 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)min, (double)(slotTop - 2), 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(max - 1), (double)(slotTop - 1), 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                bufferBuilder.m_5483_((double)(min + 1), (double)(slotTop - 1), 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                RenderSystem.disableBlend();
            }
            for (int i = 0; i < UsernameLoggerScreen.this.be.getPlayers().length; ++i) {
                if (UsernameLoggerScreen.this.be.getPlayers()[i] == null || UsernameLoggerScreen.this.be.getPlayers()[i].equals("")) continue;
                guiGraphics.m_280056_(UsernameLoggerScreen.this.f_96547_, UsernameLoggerScreen.this.be.getPlayers()[i], this.left + this.width / 2 - UsernameLoggerScreen.this.f_96547_.m_92895_(UsernameLoggerScreen.this.be.getPlayers()[i]) / 2, relativeY + 12 * i, 0xC6C6C6, false);
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

