/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.compat.pneumaticcraft.pneumatic_armor.handlers;

import ad_astra_giselle_addon.client.compat.pneumaticcraft.pneumatic_armor.handlers.AddonSimpleToggleableHandler;
import ad_astra_giselle_addon.client.compat.pneumaticcraft.pneumatic_armor.options.SpaceBreathingOption;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.AddonPNCUpgrades;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpaceBreathingClientHandler<T extends IArmorUpgradeHandler<?>>
extends AddonSimpleToggleableHandler<T> {
    private static final StatPanelLayout DEFAULT_STAT_LAYOUT = StatPanelLayout.expandsRight((float)0.5f, (float)0.005f);
    private static final ItemStack ICON = new ItemStack((ItemLike)AddonItems.OXYGEN_CAN.get());
    private IGuiAnimatedStat stat;
    private Component oxygenComponent;

    public SpaceBreathingClientHandler(T commonHandler) {
        super(commonHandler);
    }

    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new SpaceBreathingOption<SpaceBreathingClientHandler>(screen, this);
    }

    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        super.tickClient(armorHandler, isEnabled);
        if (isEnabled && this.stat.isStatOpen()) {
            Player player = armorHandler.getPlayer();
            double ratio = OxygenChargerUtils.getExtractableStoredRatio((LivingEntity)player).orElse(0.0);
            this.oxygenComponent = TranslationUtils.formatPercent(ratio);
        } else {
            this.oxygenComponent = null;
        }
    }

    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
        super.render2D(graphics, partialTicks, armorPieceHasPressure);
        if (this.stat != null && this.oxygenComponent != null && !ArmorHUDLayout.INSTANCE.getLayoutFor(this.getCommonHandler().getID(), this.getDefaultStatLayout()).hidden()) {
            Minecraft instance = Minecraft.m_91087_();
            Font fr = instance.f_91062_;
            int xl = this.stat.getBaseX() + 4;
            int yt = this.stat.getBaseY() + 16;
            if (this.stat.isLeftSided()) {
                xl -= this.stat.getStatWidth();
            }
            int iconWidth = 16;
            int iconX = xl;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            graphics.m_280480_(ICON, iconX, yt);
            RenderSystem.disableBlend();
            int componentX = iconX + iconWidth + 2;
            int componentY = yt + 4;
            graphics.m_280614_(fr, this.oxygenComponent, componentX, componentY, 0xFFFFFF, true);
        }
    }

    public IGuiAnimatedStat getAnimatedStat() {
        if (this.stat == null) {
            PNCUpgrade upgrade = AddonPNCUpgrades.SPACE_BREATHING.get();
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            int tier = Math.max(1, handler.getUpgradeCount(this.getCommonHandler().getEquipmentSlot(), upgrade));
            ItemStack stack = new ItemStack((ItemLike)upgrade.getItem(tier));
            this.stat = ClientArmorRegistry.getInstance().makeHUDStatPanel((Component)Component.m_237115_((String)this.getCommonHandler().getTranslationKey()), stack, (IArmorUpgradeClientHandler)this);
            this.stat.setMinimumContractedDimensions(0, 0);
            this.stat.setMinimumExpandedDimensions(60, 30);
        }
        return this.stat;
    }

    public void onResolutionChanged() {
        this.stat = null;
    }

    public StatPanelLayout getDefaultStatLayout() {
        return DEFAULT_STAT_LAYOUT;
    }
}

