/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.client.mixin.ad_astra.ConfigurationWidgetAccessor;
import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.network.AddonNetwork;
import ad_astra_giselle_addon.common.network.WorkingAreaVisibleMessage;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.adastra.client.components.PressableImageButton;
import earth.terrarium.adastra.client.components.machines.FluidBarWidget;
import earth.terrarium.adastra.client.components.machines.OptionsBarWidget;
import earth.terrarium.adastra.client.screens.base.MachineScreen;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.menus.base.MachineMenu;
import earth.terrarium.adastra.common.menus.configuration.FluidConfiguration;
import earth.terrarium.adastra.common.menus.configuration.MenuConfiguration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class AddonMachineScreen<MENU extends MachineMenu<BLOCK_ENTITY>, BLOCK_ENTITY extends ContainerMachineBlockEntity>
extends MachineScreen<MENU, BLOCK_ENTITY> {
    public static final Component WORKINGAREA_TEXT = Component.m_237115_((String)AddonMachineScreen.ctl("workingarea")).m_130940_(ChatFormatting.GRAY);
    private boolean cachedWorkingAreaVisible;
    protected PressableImageButton workingAreaVisibleButton;

    public static String ctl(String path) {
        return AdAstraGiselleAddon.tl("gui", path);
    }

    public static boolean shouldShowRecipeTooltip() {
        return !CompatibleManager.JEI.isLoaded() && !CompatibleManager.REI.isLoaded();
    }

    public AddonMachineScreen(MENU menu, Inventory inventory, Component title, ResourceLocation texture, ResourceLocation slotTexture, int width, int height) {
        super(menu, inventory, title, texture, slotTexture, width, height);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.hasWorkingArea()) {
            boolean visible;
            this.cachedWorkingAreaVisible = visible = this.isWorkingAreaVisible();
            this.updateWorkingAreaVisibleButton();
        }
    }

    public OptionsBarWidget.Builder createOptionsBar() {
        OptionsBarWidget.Builder builder = super.createOptionsBar();
        ContainerMachineBlockEntity containerMachineBlockEntity = this.entity;
        if (containerMachineBlockEntity instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)containerMachineBlockEntity;
            this.workingAreaVisibleButton = this.createWorkingAreaShowMode();
            builder.addElement(0, (LayoutElement)this.workingAreaVisibleButton);
        } else {
            this.workingAreaVisibleButton = null;
        }
        return builder;
    }

    @Nullable
    public PressableImageButton createWorkingAreaShowMode() {
        ContainerMachineBlockEntity containerMachineBlockEntity = this.entity;
        if (containerMachineBlockEntity instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)containerMachineBlockEntity;
            return new PressableImageButton(0, 0, 18, 18, 0, 0, 18, blockEntity.isWorkingAreaVisible() ? GuiUtils.SHOW_BUTTON : GuiUtils.HIDE_BUTTON, 18, 54, button -> this.setWorkingAreaVisible(!this.isWorkingAreaVisible()), WORKINGAREA_TEXT);
        }
        return null;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.updateWorkingAreaVisibleButton();
    }

    public boolean hasWorkingArea() {
        return this.entity instanceof IWorkingAreaBlockEntity;
    }

    public boolean isWorkingAreaVisible() {
        IWorkingAreaBlockEntity blockEntity;
        ContainerMachineBlockEntity containerMachineBlockEntity = this.entity;
        return containerMachineBlockEntity instanceof IWorkingAreaBlockEntity && (blockEntity = (IWorkingAreaBlockEntity)containerMachineBlockEntity).isWorkingAreaVisible();
    }

    @Nullable
    public AABB getWorkingArea() {
        ContainerMachineBlockEntity containerMachineBlockEntity = this.entity;
        if (containerMachineBlockEntity instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)containerMachineBlockEntity;
            return blockEntity.getWorkingArea();
        }
        return null;
    }

    public void setWorkingAreaVisible(boolean visible) {
        ContainerMachineBlockEntity machine = this.entity;
        if (machine instanceof IWorkingAreaBlockEntity) {
            IWorkingAreaBlockEntity blockEntity = (IWorkingAreaBlockEntity)machine;
            blockEntity.setWorkingAreaVisible(visible);
            AddonNetwork.CHANNEL.sendToServer((Packet)new WorkingAreaVisibleMessage(machine.m_58899_(), visible));
        }
    }

    public void updateWorkingAreaVisibleButton() {
        boolean next = this.isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
            this.workingAreaVisibleButton.setTexture(next ? GuiUtils.SHOW_BUTTON : GuiUtils.HIDE_BUTTON);
        }
    }

    public int getTextColour() {
        return 0x303030;
    }

    public FluidBarWidget getFluidBarWidget(int tank) {
        for (GuiEventListener child : this.m_6702_()) {
            FluidConfiguration fluidConfiguration;
            ConfigurationWidgetAccessor accessor;
            MenuConfiguration menuConfiguration;
            if (!(child instanceof FluidBarWidget)) continue;
            FluidBarWidget widget = (FluidBarWidget)child;
            if (!(child instanceof ConfigurationWidgetAccessor) || !((menuConfiguration = (accessor = (ConfigurationWidgetAccessor)child).getConfiguration()) instanceof FluidConfiguration) || (fluidConfiguration = (FluidConfiguration)menuConfiguration).tank() != tank) continue;
            return widget;
        }
        return null;
    }
}

