/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.util;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.fluid.FluidHelper;
import ad_astra_giselle_addon.common.registry.ObjectRegistry;
import ad_astra_giselle_addon.common.util.ModHooks;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TranslationUtils {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    public static final int DEFAULT_DIGITS = 1;
    public static final String CAN_USE = AdAstraGiselleAddon.tl("description", "can_use");
    public static final String CAN_USE_COLD = AdAstraGiselleAddon.tl("description", "can_use.cold");
    public static final String CAN_USE_HOT = AdAstraGiselleAddon.tl("description", "can_use.hot");
    public static final String CAN_USE_AVAILABLE = AdAstraGiselleAddon.tl("can_use", "available");
    public static final String CAN_USE_UNAVAILABLE = AdAstraGiselleAddon.tl("can_use", "unavailable");
    public static final String CHARGE_MODE = AdAstraGiselleAddon.tl("description", "charge_mode");
    private static final Map<IChargeMode, Component> CHANGE_MODES = new HashMap<IChargeMode, Component>();

    public static Component getItemTooltip(ResourceLocation id) {
        return TranslationUtils.getItemTooltip(id.m_135827_(), id.m_135815_(), "");
    }

    public static Component getItemTooltip(ResourceLocation id, String suffix) {
        return TranslationUtils.getItemTooltip(id.m_135827_(), id.m_135815_(), suffix);
    }

    public static Component getItemTooltip(String namespace, String path, String suffix) {
        String tooltipKey = "item." + namespace + "." + path + ".tooltip" + suffix;
        return TranslationUtils.styleItemTooltip((Component)Component.m_237115_((String)tooltipKey));
    }

    public static Component styleItemTooltip(Component component) {
        return Component.m_237119_().m_7220_(component).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
    }

    public static Component description(String key, Component component) {
        MutableComponent value = Component.m_237113_((String)"").m_130940_(ChatFormatting.WHITE).m_7220_(component);
        return Component.m_237115_((String)key).m_130940_(ChatFormatting.BLUE).m_130946_(": ").m_7220_((Component)value);
    }

    public static List<Component> descriptionCanUse(boolean canUseOnCold, boolean canUseOnHot) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(TranslationUtils.descriptionCanUse(CAN_USE_COLD, canUseOnCold));
        list.add(TranslationUtils.descriptionCanUse(CAN_USE_HOT, canUseOnHot));
        return list;
    }

    private static Component descriptionCanUse(String key, boolean canUse) {
        return TranslationUtils.description(key, (Component)Component.m_237115_((String)(canUse ? CAN_USE_AVAILABLE : CAN_USE_UNAVAILABLE)).m_130940_(canUse ? ChatFormatting.GREEN : ChatFormatting.RED));
    }

    public static Component descriptionChargeMode(IChargeMode mode) {
        if (mode == null) {
            return Component.m_237119_();
        }
        return CHANGE_MODES.computeIfAbsent(mode, k -> TranslationUtils.description(CHARGE_MODE, k.getDisplayName()));
    }

    public static Component oxygenStorage(long amount, long capacity) {
        long amountMB = FluidConstants.toMillibuckets((long)amount);
        long capacityMB = FluidConstants.toMillibuckets((long)capacity);
        Style style = Style.f_131099_.m_131140_(amountMB > 0L ? ChatFormatting.GREEN : ChatFormatting.RED);
        return Component.m_237110_((String)"tooltip.ad_astra.space_suit", (Object[])new Object[]{amountMB, capacityMB}).m_6270_(style);
    }

    public static List<Component> fluid(FluidContainer container) {
        ArrayList<Component> list = new ArrayList<Component>();
        int size = container.getSize();
        List fluids = container.getFluids();
        for (int i = 0; i < size; ++i) {
            FluidHolder fluid = (FluidHolder)fluids.get(i);
            long capacity = container.getTankCapacity(i);
            list.addAll(TranslationUtils.fluid(fluid, capacity));
        }
        return list;
    }

    public static List<Component> fluid(FluidHolder fluid, long capacity) {
        String modid = ObjectRegistry.get(Registries.f_256808_).getId(fluid.getFluid()).m_135827_();
        Component name = FluidHelper.getDisplayName(fluid);
        long amountMB = FluidConstants.toMillibuckets((long)fluid.getFluidAmount());
        long capacityMB = FluidConstants.toMillibuckets((long)capacity);
        MutableComponent storage = Component.m_237110_((String)"gauge_text.ad_astra.liquid_storage", (Object[])new Object[]{amountMB, capacityMB});
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)storage.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_(Component.m_130674_((String)", ")).m_7220_(name));
        list.add((Component)Component.m_237113_((String)ModHooks.getName(modid)).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE)));
        return list;
    }

    public static Component formatPercent(double ratio) {
        return Component.m_237113_((String)NUMBER_FORMAT.format(ratio * 100.0)).m_130946_("%");
    }

    private TranslationUtils() {
    }

    static {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(1);
    }
}

