/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.filler.SkipIterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class FillerAction {
    private static final Logger LOGGER = QuarryPlus.getLogger(FillerAction.class);
    @Nullable
    SkipIterator iterator = null;

    public void tick(Supplier<Optional<ItemStack>> stackProvider, PowerTile powerSource, long energy) {
        if (this.iterator == null || powerSource.m_58904_() == null) {
            return;
        }
        Optional<ItemStack> maybeStack = stackProvider.get();
        Level level = powerSource.m_58904_();
        maybeStack.ifPresent(blockStack -> {
            BlockPos targetPos = this.iterator.peek(FillerAction.predicate(level, blockStack));
            if (targetPos == null) {
                this.iterator = null;
            } else if (powerSource.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                DirectionalPlaceContext context = new DirectionalPlaceContext(level, targetPos, Direction.DOWN, blockStack, Direction.UP);
                BlockState state = FillerAction.getStateFromItem((BlockItem)blockStack.m_41720_(), context);
                if (state != null) {
                    level.m_7731_(targetPos, state, 3);
                    blockStack.m_41774_(1);
                }
                this.iterator.commit(targetPos, false);
            }
        });
    }

    public void tick(Level level, PowerTile powerSource, long energy) {
        if (this.iterator == null || powerSource.m_58904_() == null) {
            return;
        }
        BlockPos targetPos = this.iterator.peek(FillerAction.predicate(level));
        if (targetPos == null) {
            this.iterator = null;
        } else {
            BlockState toPlace = FillerAction.getToReplace((ResourceKey<Level>)level.m_46472_(), targetPos);
            if (powerSource.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                level.m_7731_(targetPos, toPlace, 3);
                this.iterator.commit(targetPos, false);
            }
        }
    }

    public boolean isFinished() {
        return this.iterator == null;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        if (this.iterator != null) {
            tag.m_128365_("iterator", (Tag)this.iterator.toNbt());
        }
        return tag;
    }

    public void fromNbt(CompoundTag tag) {
        if (tag.m_128441_("iterator")) {
            this.iterator = SkipIterator.fromNbt(tag.m_128469_("iterator"));
        }
    }

    public void setIterator(@Nullable SkipIterator iterator) {
        this.iterator = iterator;
    }

    private static Predicate<BlockPos> predicate(Level level, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return pos -> {
                DirectionalPlaceContext context = new DirectionalPlaceContext(level, pos, Direction.DOWN, stack, Direction.UP);
                BlockState state = FillerAction.getStateFromItem(blockItem, context);
                if (!context.m_7059_() || state == null) {
                    return false;
                }
                return level.m_45752_(state, pos, CollisionContext.m_82749_());
            };
        }
        return pos -> false;
    }

    private static Predicate<BlockPos> predicate(Level level) {
        return pos -> {
            BlockState state = FillerAction.getToReplace((ResourceKey<Level>)level.m_46472_(), pos);
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            DirectionalPlaceContext context = new DirectionalPlaceContext(level, pos, Direction.DOWN, stack, Direction.UP);
            if (!context.m_7059_()) {
                return false;
            }
            return level.m_45752_(state, pos, CollisionContext.m_82749_());
        };
    }

    @Nullable
    private static BlockState getStateFromItem(BlockItem blockItem, DirectionalPlaceContext context) {
        try {
            return (BlockState)ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"m_5965_", (Class[])new Class[]{BlockPlaceContext.class}).invoke((Object)blockItem, context);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Caught exception in Filler", (Throwable)e);
            return null;
        }
    }

    public static BlockState getToReplace(ResourceKey<Level> dimension, BlockPos pos) {
        if (dimension.equals((Object)Level.f_46429_)) {
            return Blocks.f_50134_.m_49966_();
        }
        if (dimension.equals((Object)Level.f_46430_)) {
            return Blocks.f_50259_.m_49966_();
        }
        if (dimension.equals((Object)Level.f_46428_)) {
            if (pos.m_123342_() >= 0) {
                return Blocks.f_50069_.m_49966_();
            }
            return Blocks.f_152550_.m_49966_();
        }
        return Blocks.f_50069_.m_49966_();
    }
}

