/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.InvUtils;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipe;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TileWorkbench
extends PowerTile
implements Container,
MenuProvider,
CheckerLog {
    final List<ItemStack> ingredientInventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    final List<ItemStack> selectionInventory = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    public List<WorkbenchRecipe> recipesList = Collections.emptyList();
    private WorkbenchRecipe currentRecipe = WorkbenchRecipe.dummyRecipe();
    private final ItemHandler itemHandler = new ItemHandler();
    public boolean workContinue;
    private Runnable initRecipeTask = null;
    private final List<Player> openPlayers = new ArrayList<Player>();

    public TileWorkbench(BlockPos pos, BlockState state) {
        super(Holder.WORKBENCH_TYPE, pos, state);
    }

    public void tick() {
        if (!this.enabled || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.initRecipeTask != null) {
            this.initRecipeTask.run();
            this.initRecipeTask = null;
        }
        if (this.currentRecipe.hasContent() && this.currentRecipe.getRequiredEnergy() <= this.getEnergy()) {
            this.useEnergy(this.currentRecipe.getRequiredEnergy(), PowerTile.Reason.WORKBENCH, true);
            ItemStack created = this.currentRecipe.getOutput(this.ingredientInventory, this.f_58857_.m_9598_());
            ItemStack toSpawnInWorld = InvUtils.injectToNearTile(this.f_58857_, this.m_58899_(), created);
            if (!toSpawnInWorld.m_41619_()) {
                Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)toSpawnInWorld);
            }
            this.currentRecipe.consumeItems(this.ingredientInventory);
            this.updateRecipeOutputs();
            this.setCurrentRecipe(this.workContinue ? this.currentRecipe.m_6423_() : WorkbenchRecipe.dummyRecipe().m_6423_());
        } else if (((Boolean)QuarryPlus.config.common.noEnergy.get()).booleanValue()) {
            this.addEnergy(this.currentRecipe.getRequiredEnergy() / 200L, false);
        } else {
            this.addEnergy(5000000000L, false);
        }
        if (!this.openPlayers.isEmpty()) {
            PacketHandler.sendToClient(new TileMessage(this), this.f_58857_);
        }
    }

    @Override
    public void onLoad() {
        MinecraftServer server;
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.initRecipeTask != null && (server = this.f_58857_.m_7654_()) != null) {
            server.m_6937_((Runnable)new TickTask(server.m_129921_(), this.initRecipeTask));
            this.initRecipeTask = null;
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ListTag list = nbt.m_128437_("Items", 10);
        list.stream().mapMulti(MapMulti.cast(CompoundTag.class)).forEach(nbtTagCompound -> {
            byte slot = nbtTagCompound.m_128445_("Slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtTagCompound);
            stack.m_41764_(nbtTagCompound.m_128451_("Count"));
            this.ingredientInventory.set(slot, stack);
        });
        ResourceLocation recipeLocation = new ResourceLocation(nbt.m_128461_("recipe"));
        this.initRecipeTask = () -> {
            this.updateRecipeOutputs();
            this.setCurrentRecipe(recipeLocation);
        };
    }

    @Override
    public void saveNbtData(CompoundTag nbt) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.ingredientInventory.size(); ++i) {
            ItemStack stack = this.ingredientInventory.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128344_("Slot", (byte)i);
            stack.m_41739_(compoundNBT);
            compoundNBT.m_128473_("Count");
            compoundNBT.m_128405_("Count", stack.m_41613_());
            items.add((Object)compoundNBT);
        }
        nbt.m_128365_("Items", (Tag)items);
        nbt.m_128359_("recipe", this.currentRecipe.m_6423_().toString());
    }

    public int m_6643_() {
        return 45;
    }

    public boolean m_7983_() {
        return this.ingredientInventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        if (this.ingredientInventory.size() <= index && index < this.m_6643_()) {
            return this.selectionInventory.get(index - this.ingredientInventory.size());
        }
        return this.ingredientInventory.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (this.ingredientInventory.size() <= index && index < this.m_6643_()) {
            return ContainerHelper.m_18969_(this.selectionInventory, (int)(index - this.ingredientInventory.size()), (int)count);
        }
        ItemStack stack = ContainerHelper.m_18969_(this.ingredientInventory, (int)index, (int)count);
        this.updateRecipeOutputs();
        return stack;
    }

    public ItemStack m_8016_(int index) {
        if (this.ingredientInventory.size() <= index && index < this.m_6643_()) {
            return ContainerHelper.m_18966_(this.selectionInventory, (int)(index - this.ingredientInventory.size()));
        }
        return ContainerHelper.m_18966_(this.ingredientInventory, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (this.ingredientInventory.size() <= index && index < this.m_6643_()) {
            this.selectionInventory.set(index - this.ingredientInventory.size(), stack);
        } else {
            this.ingredientInventory.set(index, stack);
            this.updateRecipeOutputs();
        }
    }

    public int m_6893_() {
        return Integer.MAX_VALUE;
    }

    public void m_6211_() {
        this.ingredientInventory.clear();
        this.updateRecipeOutputs();
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pIndex < this.ingredientInventory.size();
    }

    @Override
    public List<? extends Component> getDebugLogs() {
        return Stream.of("%sRecipe:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.currentRecipe), "%sWorkContinue:%s %b".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.workContinue), "%sRecipe List:%s %s".formatted(ChatFormatting.GREEN, ChatFormatting.RESET, this.recipesList), this.energyString()).map(Component::m_237113_).toList();
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public boolean m_6542_(Player player) {
        return TileWorkbench.stillValid(this, player);
    }

    public void m_6596_() {
        super.m_6596_();
        this.updateRecipeOutputs();
    }

    private void updateRecipeOutputs() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateRecipeList(this.f_58857_.m_9598_());
            if (!this.recipesList.contains(this.currentRecipe) && this.currentRecipe.hasContent()) {
                this.setCurrentRecipe(WorkbenchRecipe.dummyRecipe().m_6423_());
                this.logUsage();
            }
            PacketHandler.sendToClient(new TileMessage(this), this.f_58857_);
        }
    }

    @VisibleForTesting
    void updateRecipeList(RegistryAccess access) {
        this.recipesList = WorkbenchRecipe.getRecipeFinder().getRecipes(this.ingredientInventory);
        this.selectionInventory.clear();
        for (int i = 0; i < this.recipesList.size(); ++i) {
            this.m_6836_(this.ingredientInventory.size() + i, this.recipesList.get(i).m_8043_(access));
        }
    }

    public void setCurrentRecipe(ResourceLocation recipeName) {
        this.currentRecipe = this.recipesList.stream().filter(r -> recipeName.equals((Object)r.m_6423_())).findFirst().orElse(WorkbenchRecipe.dummyRecipe());
        this.setMaxEnergy(Math.max(this.currentRecipe.getRequiredEnergy(), 5L));
        if (((Boolean)QuarryPlus.config.common.noEnergy.get()).booleanValue()) {
            this.setEnergy(0L, true);
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        return super.getCapability(cap, side);
    }

    public WorkbenchRecipe getRecipe() {
        return this.currentRecipe;
    }

    public int getProgressScaled(int scale) {
        if (this.currentRecipe.hasContent()) {
            return (int)(this.getEnergy() * (long)scale / this.currentRecipe.getRequiredEnergy());
        }
        return 0;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new ContainerWorkbench(id, player, this.m_58899_());
    }

    public void m_5856_(Player player) {
        this.openPlayers.add(player);
    }

    public void m_5785_(Player player) {
        this.openPlayers.remove(player);
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TileWorkbench.this.m_6836_(slot, stack);
        }

        public int getSlots() {
            return TileWorkbench.this.ingredientInventory.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileWorkbench.this.m_8020_(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack inSlot = this.getStackInSlot(slot).m_41777_();
            if (!inSlot.m_41619_()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)stack)) {
                    if (!simulate) {
                        inSlot.m_41769_(stack.m_41613_());
                        this.setStackInSlot(slot, inSlot);
                        TileWorkbench.this.m_6596_();
                    }
                    return ItemStack.f_41583_;
                }
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack.m_41777_());
                TileWorkbench.this.m_6596_();
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted;
            if (!((Boolean)QuarryPlus.config.common.allowWorkbenchExtraction.get()).booleanValue()) {
                return ItemStack.f_41583_;
            }
            ItemStack itemInSlot = this.getStackInSlot(slot);
            if (itemInSlot.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int extractAmount = Math.min(itemInSlot.m_41613_(), amount);
            if (simulate) {
                extracted = ItemHandlerHelper.copyStackWithSize((ItemStack)itemInSlot, (int)extractAmount);
            } else {
                extracted = itemInSlot.m_41620_(extractAmount);
                TileWorkbench.this.m_6596_();
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return TileWorkbench.this.m_6893_();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileWorkbench.this.m_7013_(slot, stack);
        }
    }
}

