/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.TableHelper;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFilter {
    private Fluid fluid = Fluids.f_76191_;
    private TagKey<Fluid> tag = null;
    private CompoundTag nbt = null;
    private int count = 1000;
    private String fingerprint = "";

    private FluidFilter() {
    }

    public static Pair<FluidFilter, String> parse(Map<?, ?> item) {
        FluidFilter fluidFilter = FluidFilter.empty();
        if (item.isEmpty()) {
            return Pair.of(fluidFilter, null);
        }
        if (item.containsKey("name")) {
            try {
                String name = TableHelper.getStringField(item, (String)"name");
                if (name.startsWith("#")) {
                    fluidFilter.tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(name.substring(1)));
                } else {
                    fluidFilter.fluid = (Fluid)ItemUtil.getRegistryEntry(name, ForgeRegistries.FLUIDS);
                    if (fluidFilter.fluid == null) {
                        return Pair.of(null, "FLUID_NOT_FOUND");
                    }
                }
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FLUID");
            }
        }
        if (item.containsKey("nbt")) {
            try {
                fluidFilter.nbt = NBTUtil.fromText(TableHelper.getStringField(item, (String)"nbt"));
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_NBT");
            }
        }
        if (item.containsKey("fingerprint")) {
            try {
                fluidFilter.fingerprint = TableHelper.getStringField(item, (String)"fingerprint");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_FINGERPRINT");
            }
        }
        if (item.containsKey("count")) {
            try {
                fluidFilter.count = TableHelper.getIntField(item, (String)"count");
            }
            catch (LuaException luaException) {
                return Pair.of(null, "NO_VALID_COUNT");
            }
        }
        AdvancedPeripherals.debug("Parsed fluid filter: " + fluidFilter);
        return Pair.of(fluidFilter, null);
    }

    public static FluidFilter fromStack(FluidStack stack) {
        FluidFilter filter = FluidFilter.empty();
        filter.fluid = stack.getFluid();
        filter.nbt = stack.hasTag() ? stack.getTag() : null;
        return filter;
    }

    public static FluidFilter empty() {
        return new FluidFilter();
    }

    public boolean isEmpty() {
        return this.fingerprint.isEmpty() && this.fluid == Fluids.f_76191_ && this.tag == null && this.nbt == null;
    }

    public FluidStack toFluidStack() {
        FluidStack result = new FluidStack(this.fluid, this.count);
        result.setTag(this.nbt != null ? this.nbt.m_6426_() : null);
        return result;
    }

    public FluidFilter setCount(int count) {
        this.count = count;
        return this;
    }

    public boolean test(FluidStack stack) {
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = FluidUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (this.fluid != Fluids.f_76191_ && this.tag == null && this.nbt == null && this.fingerprint.isEmpty()) {
            return stack.getFluid().m_6212_(this.fluid);
        }
        if (this.tag != null && !stack.getFluid().m_205067_(this.tag)) {
            return false;
        }
        return this.nbt == null || stack.getOrCreateTag().equals((Object)this.nbt) || this.fluid != Fluids.f_76191_ && !stack.getFluid().m_6212_(this.fluid);
    }

    public int getCount() {
        return this.count;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Tag getNbt() {
        return this.nbt;
    }

    public String toString() {
        return "FluidFilter{fluid=" + FluidUtil.getRegistryKey(this.fluid) + ", tag=" + this.tag + ", nbt=" + this.nbt + ", count=" + this.count + ", fingerprint='" + this.fingerprint + "'}";
    }
}

