/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.blockentities;

import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.EnergyDetectorPeripheral;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.EnergyStorageProxy;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyDetectorEntity
extends PeripheralBlockEntity<EnergyDetectorPeripheral> {
    private final EnergyStorage zeroStorage = new EnergyStorage(0, 0, 0);
    public int transferRate = 0;
    public EnergyStorageProxy storageProxy;
    LazyOptional<IEnergyStorage> energyStorageCap;
    Direction energyInDirection;
    Direction energyOutDirection;
    LazyOptional<IEnergyStorage> zeroStorageCap;
    @NotNull
    private Optional<IEnergyStorage> outReceivingStorage;

    public EnergyDetectorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.ENERGY_DETECTOR.get(), pos, state);
        this.storageProxy = new EnergyStorageProxy(this, (Integer)APConfig.PERIPHERALS_CONFIG.energyDetectorMaxFlow.get());
        this.energyStorageCap = LazyOptional.of(() -> this.storageProxy);
        this.energyInDirection = Direction.NORTH;
        this.energyOutDirection = Direction.SOUTH;
        this.zeroStorageCap = LazyOptional.of(() -> this.zeroStorage);
        this.outReceivingStorage = Optional.empty();
    }

    @Override
    @NotNull
    protected EnergyDetectorPeripheral createPeripheral() {
        return new EnergyDetectorPeripheral(this);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction direction) {
        this.energyInDirection = ((FrontAndTop)this.m_58900_().m_61143_((Property)JigsawBlock.f_54222_)).m_122625_();
        this.energyOutDirection = ((FrontAndTop)this.m_58900_().m_61143_((Property)JigsawBlock.f_54222_)).m_122625_().m_122424_();
        if (cap == ForgeCapabilities.ENERGY) {
            if (direction == this.energyInDirection) {
                return this.energyStorageCap.cast();
            }
            if (direction == this.energyOutDirection) {
                return this.zeroStorageCap.cast();
            }
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("rateLimit", this.storageProxy.getMaxTransferRate());
    }

    @Override
    public <T extends BlockEntity> void handleTick(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            this.transferRate = this.storageProxy.getTransferedInThisTick();
            this.storageProxy.resetTransferedInThisTick();
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.storageProxy.setMaxTransferRate(nbt.m_128451_("rateLimit"));
        super.deserializeNBT(nbt);
    }

    @NotNull
    public Optional<IEnergyStorage> getOutputStorage() {
        if (this.outReceivingStorage.isEmpty()) {
            BlockEntity teOut = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.energyOutDirection));
            if (teOut == null) {
                return Optional.empty();
            }
            LazyOptional lazyOptionalOutStorage = teOut.getCapability(ForgeCapabilities.ENERGY, this.energyOutDirection.m_122424_());
            this.outReceivingStorage = lazyOptionalOutStorage.resolve();
            lazyOptionalOutStorage.addListener(l -> {
                this.outReceivingStorage = Optional.empty();
            });
        }
        return this.outReceivingStorage;
    }
}

