/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.TelepathicAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.commands.BossCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.CategoryCheckCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.GemCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.LootifyCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.ModifierCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.RarityCommand;
import dev.shadowsoffire.apotheosis.adventure.commands.SocketCommand;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.ItemAccess;
import dev.shadowsoffire.placebo.events.AnvilLandEvent;
import dev.shadowsoffire.placebo.events.GetEnchantmentLevelEvent;
import dev.shadowsoffire.placebo.events.ItemUseEvent;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AdventureEvents {
    private static final UUID HEAVY_WEAPON_AS = UUID.fromString("f8c3de3d-1fea-4d7c-a8b0-29f63c4c3454");
    private static ThreadLocal<AtomicBoolean> reentrantLock = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    @SubscribeEvent
    public void cmds(Apotheosis.ApotheosisCommandEvent e) {
        RarityCommand.register(e.getRoot());
        CategoryCheckCommand.register(e.getRoot());
        LootifyCommand.register(e.getRoot());
        ModifierCommand.register(e.getRoot());
        GemCommand.register(e.getRoot());
        SocketCommand.register(e.getRoot());
        BossCommand.register(e.getRoot());
    }

    @SubscribeEvent
    public void affixModifiers(ItemAttributeModifierEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            affixes.forEach((afx, inst) -> inst.addModifiers(e.getSlotType(), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)e).addModifier(arg_0, arg_1)));
            if (!affixes.isEmpty() && LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && e.getSlotType() == EquipmentSlot.MAINHAND) {
                double value;
                double clampedAmt;
                double amt = -0.15 - 0.1 * (double)((LootRarity)affixes.values().stream().findAny().get().rarity().get()).ordinal();
                AttributeModifier baseAS = e.getModifiers().get((Object)Attributes.f_22283_).stream().filter(a -> ItemAccess.getBaseAS() == a.m_22209_()).findFirst().orElse(null);
                if (baseAS != null && (amt = Math.max(amt, clampedAmt = (double)0.4f / (value = 4.0 + baseAS.m_22218_()) - 1.0)) >= 0.0) {
                    return;
                }
                e.addModifier(Attributes.f_22283_, new AttributeModifier(HEAVY_WEAPON_AS, "Heavy Weapon AS", amt, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void preventBossSuffocate(LivingHurtEvent e) {
        if (e.getSource().m_276093_(DamageTypes.f_268612_) && e.getEntity().getPersistentData().m_128441_("apoth.boss")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void fireArrow(EntityJoinLevelEvent e) {
        Entity shooter;
        AbstractArrow arrow;
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow && !(arrow = (AbstractArrow)entity).getPersistentData().m_128471_("apoth.generated") && (shooter = arrow.m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)shooter;
            ItemStack bow = living.m_21211_();
            if (bow.m_41619_() && ((bow = living.m_21205_()).m_41619_() || !LootCategory.forItem(bow).isRanged())) {
                bow = living.m_21206_();
            }
            if (bow.m_41619_()) {
                return;
            }
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(bow);
            affixes.values().forEach(a -> a.onArrowFired(living, arrow));
            AffixHelper.copyFrom(bow, (Entity)arrow);
        }
    }

    @SubscribeEvent
    public void impact(ProjectileImpactEvent e) {
        Projectile projectile = e.getProjectile();
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            Map<DynamicHolder<Affix>, AffixInstance> affixes = AffixHelper.getAffixes((Entity)arrow);
            affixes.values().forEach(inst -> inst.onArrowImpact(arrow, e.getRayTraceResult(), e.getRayTraceResult().m_6662_()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDamage(LivingHurtEvent e) {
        Apoth.Affixes.MAGICAL.getOptional().ifPresent(afx -> afx.onHurt(e));
        DamageSource src = e.getSource();
        LivingEntity ent = e.getEntity();
        float amount = e.getAmount();
        for (ItemStack s : ent.m_20158_()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                amount = inst.onHurt(src, ent, amount);
            }
        }
        e.setAmount(amount);
    }

    @SubscribeEvent
    public void onItemUse(ItemUseEvent e) {
        ItemStack s = e.getItemStack();
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
        for (AffixInstance inst : affixes.values()) {
            InteractionResult type = inst.onItemUse(e.getContext());
            if (type == null) continue;
            e.setCanceled(true);
            e.setCancellationResult(type);
        }
    }

    @SubscribeEvent
    public void shieldBlock(ShieldBlockEvent e) {
        ItemStack stack = e.getEntity().m_21211_();
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        float blocked = e.getBlockedDamage();
        for (AffixInstance inst : affixes.values()) {
            blocked = inst.onShieldBlock(e.getEntity(), e.getDamageSource(), blocked);
        }
        if (blocked != e.getOriginalBlockedDamage()) {
            e.setBlockedDamage(blocked);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent e) {
        ItemStack stack = e.getPlayer().m_21205_();
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        for (AffixInstance inst : affixes.values()) {
            inst.onBlockBreak(e.getPlayer(), e.getLevel(), e.getPos(), e.getState());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dropsHigh(LivingDropsEvent e) {
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)entity;
            if (e.getEntity() instanceof Monster) {
                if (p instanceof FakePlayer) {
                    return;
                }
                float chance = AdventureConfig.gemDropChance + (e.getEntity().getPersistentData().m_128441_("apoth.boss") ? AdventureConfig.gemBossBonus : 0.0f);
                if (p.f_19796_.m_188501_() <= chance) {
                    LivingEntity ent = e.getEntity();
                    e.getDrops().add(new ItemEntity(ent.m_9236_(), ent.m_20185_(), ent.m_20186_(), ent.m_20189_(), GemRegistry.createRandomGemStack(p.f_19796_, (ServerLevel)p.m_9236_(), p.m_36336_(), WeightedDynamicRegistry.IDimensional.matches((Level)p.m_9236_()), GameStagesCompat.IStaged.matches((Player)p)), 0.0, 0.0, 0.0));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) {
        Apoth.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.drops(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void deathMark(LivingDeathEvent e) {
        Apoth.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.markEquipment(e));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        TelepathicAffix.drops(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void festive_removeMarker(LivingDropsEvent e) {
        Apoth.Affixes.FESTIVE.getOptional().ifPresent(afx -> afx.removeMarker(e));
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck e) {
        Apoth.Affixes.OMNETIC.getOptional().ifPresent(afx -> afx.harvest(e));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void speed(PlayerEvent.BreakSpeed e) {
        Apoth.Affixes.OMNETIC.getOptional().ifPresent(afx -> afx.speed(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(BlockEvent.BreakEvent e) {
        Apoth.Affixes.RADIAL.getOptional().ifPresent(afx -> afx.onBreak(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void special(MobSpawnEvent.FinalizeSpawn e) {
        if (e.getSpawnType() == MobSpawnType.NATURAL && e.getLevel().m_213780_().m_188501_() <= AdventureConfig.randomAffixItem && e.getEntity() instanceof Monster) {
            Player player = e.getLevel().m_45924_(e.getX(), e.getY(), e.getZ(), -1.0, false);
            if (player == null) {
                return;
            }
            ItemStack affixItem = LootController.createRandomLootItem(e.getLevel().m_213780_(), null, player, (ServerLevelAccessor)((ServerLevel)e.getEntity().m_9236_()));
            if (affixItem.m_41619_()) {
                return;
            }
            affixItem.m_41784_().m_128379_("apoth_rspawn", true);
            LootCategory cat = LootCategory.forItem(affixItem);
            EquipmentSlot slot = cat.getSlots()[0];
            e.getEntity().m_8061_(slot, affixItem);
            e.getEntity().m_21508_(slot);
        }
    }

    @SubscribeEvent
    public void gemSmashing(AnvilLandEvent e) {
        Level level = e.getLevel();
        BlockPos pos = e.getPos();
        List items = level.m_45976_(ItemEntity.class, new AABB(pos, pos.m_7918_(1, 1, 1)));
        for (ItemEntity ent : items) {
            ItemStack stack = ent.m_32055_();
            if (stack.m_41720_() != Adventure.Items.GEM.get()) continue;
            ent.m_32045_(new ItemStack((ItemLike)Adventure.Items.GEM_DUST.get(), stack.m_41613_()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void enchLevels(GetEnchantmentLevelEvent e) {
        boolean isReentrant = reentrantLock.get().getAndSet(true);
        if (isReentrant) {
            return;
        }
        AffixHelper.streamAffixes(e.getStack()).forEach(inst -> inst.getEnchantmentLevels(e.getEnchantments()));
        reentrantLock.get().set(false);
    }

    @SubscribeEvent
    public void update(LivingEvent.LivingTickEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.getPersistentData().m_128441_("apoth.burns_in_sun") && entity.m_9236_().m_46461_() && !entity.m_9236_().f_46443_) {
            boolean flag;
            float f = entity.m_213856_();
            BlockPos blockpos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_());
            boolean bl = flag = entity.m_20071_() || entity.f_146808_ || entity.f_146809_;
            if (f > 0.5f && entity.f_19796_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && entity.m_9236_().m_45527_(blockpos)) {
                entity.m_20254_(8);
            }
        }
    }
}

