/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.attributeslib.util.AttributesUtil;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class DamageReductionAffix
extends Affix {
    public static final Codec<DamageReductionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(a -> a.type), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, DamageReductionAffix::new));
    protected final DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;

    public DamageReductionAffix(DamageType type, Map<LootRarity, StepFunction> levelFuncs, Set<LootCategory> types) {
        super(AffixType.ABILITY);
        this.type = type;
        this.values = levelFuncs;
        this.types = types;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return !cat.isNone() && (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MutableComponent comp = Component.m_237110_((String)"affix.apotheosis:damage_reduction.desc", (Object[])new Object[]{Component.m_237115_((String)("misc.apotheosis." + this.type.id)), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
        list.accept((Component)comp);
    }

    @Override
    public float onHurt(ItemStack stack, LootRarity rarity, float level, DamageSource src, LivingEntity ent, float amount) {
        if (src.m_269533_(DamageTypeTags.f_268738_) || src.m_269533_(DamageTypeTags.f_268413_)) {
            return amount;
        }
        if (this.type.test(src)) {
            return amount * (1.0f - this.getTrueLevel(rarity, level));
        }
        return super.onHurt(stack, rarity, level, src, ent, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static enum DamageType implements Predicate<DamageSource>
    {
        PHYSICAL("physical", AttributesUtil::isPhysicalDamage),
        MAGIC("magic", d -> d.m_269533_(DamageTypeTags.f_268490_)),
        FIRE("fire", d -> d.m_269533_(DamageTypeTags.f_268745_)),
        FALL("fall", d -> d.m_269533_(DamageTypeTags.f_268549_)),
        EXPLOSION("explosion", d -> d.m_269533_(DamageTypeTags.f_268415_));

        public static Codec<DamageType> CODEC;
        private final String id;
        private final Predicate<DamageSource> predicate;

        private DamageType(String id, Predicate<DamageSource> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean test(DamageSource t) {
            return this.predicate.test(t);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(DamageType.class);
        }
    }
}

