/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;

public record GemClass(String key, Set<LootCategory> types) {
    public static Codec<GemClass> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("key").forGetter(GemClass::key), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(GemClass::types)).apply((Applicative)inst, GemClass::new));

    public GemClass(String key, Set<LootCategory> types) {
        this.key = key;
        this.types = types;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.key) ? 1 : 0) != 0, (Object)"Invalid GemClass with null key");
        Preconditions.checkArgument((this.types != null && !this.types.isEmpty() ? 1 : 0) != 0, (Object)"Invalid GemClass with null or empty types");
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.key);
        buf.writeByte(this.types.size());
        this.types.forEach(c -> buf.m_130070_(c.getName()));
    }

    public static GemClass read(FriendlyByteBuf buf) {
        String key = buf.m_130277_();
        int size = buf.readByte();
        ArrayList<LootCategory> list = new ArrayList<LootCategory>(size);
        for (int i = 0; i < size; ++i) {
            list.add(LootCategory.byId(buf.m_130277_()));
        }
        return new GemClass(key, (Set<LootCategory>)ImmutableSet.copyOf(list));
    }
}

