/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.village.wanderer.JsonTrade;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ServerLevelAccessor;

public class AffixTrade
implements JsonTrade {
    public static final Codec<AffixTrade> CODEC = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("input_1").forGetter(a -> a.price), (App)PlaceboCodecs.nullableField((Codec)ItemAdapter.CODEC, (String)"input_2", (Object)ItemStack.f_41583_).forGetter(a -> a.price2), (App)PlaceboCodecs.nullableField(RarityClamp.Simple.CODEC, (String)"rarities", (Object)RarityClamp.UNCLAMPED).forGetter(a -> a.rarities), (App)AffixLootRegistry.INSTANCE.holderCodec().listOf().fieldOf("entries").forGetter(a -> a.entries), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"rare", (Object)false).forGetter(a -> a.rare)).apply((Applicative)inst, AffixTrade::new)));
    protected final ItemStack price;
    protected final ItemStack price2;
    protected final RarityClamp.Simple rarities;
    protected final List<DynamicHolder<AffixLootEntry>> entries;
    protected final boolean rare;

    public AffixTrade(ItemStack price, ItemStack price2, RarityClamp.Simple rarities, List<DynamicHolder<AffixLootEntry>> entries, boolean rare) {
        this.price = price;
        this.price2 = price2;
        this.rarities = rarities;
        this.entries = entries;
        this.rare = rare;
    }

    @Nullable
    public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
        ItemStack affixItem;
        if (trader.m_9236_().f_46443_) {
            return null;
        }
        Player player = trader.m_9236_().m_45930_(trader, -1.0);
        if (player == null) {
            return null;
        }
        if (this.entries.isEmpty()) {
            LootRarity selectedRarity = LootRarity.random(rand, player.m_36336_(), this.rarities);
            affixItem = LootController.createRandomLootItem(rand, selectedRarity, player, (ServerLevelAccessor)trader.m_9236_());
        } else {
            List<WeightedEntry.Wrapper> resolved = this.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(player.m_36336_())).toList();
            AffixLootEntry entry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.m_216822_((RandomSource)rand, resolved).get()).m_146310_();
            LootRarity selectedRarity = LootRarity.random(rand, player.m_36336_(), this.rarities == RarityClamp.UNCLAMPED ? entry : this.rarities);
            affixItem = LootController.createLootItem(entry.getStack().m_41777_(), selectedRarity, rand);
        }
        if (affixItem.m_41619_()) {
            return null;
        }
        affixItem.m_41783_().m_128379_("apoth_merchant", true);
        return new MerchantOffer(this.price, this.price2, affixItem, 1, 100, 1.0f);
    }

    @Override
    public boolean isRare() {
        return this.rare;
    }

    public Codec<? extends JsonTrade> getCodec() {
        return CODEC;
    }

    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            AdventureModule.LOGGER.error("An AffixTrade failed to resolve the Affix Loot Entry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }
}

