/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import java.util.stream.DoubleStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getHoverName"}, at={@At(value="RETURN")}, cancellable=true)
    public void apoth_affixItemName(CallbackInfoReturnable<Component> ci) {
        ItemStack ths = (ItemStack)this;
        CompoundTag afxData = ths.m_41737_("affix_data");
        if (afxData != null && afxData.m_128425_("name", 8)) {
            try {
                Component component = AffixHelper.getName(ths);
                ComponentContents componentContents = component.m_214077_();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents tContents = (TranslatableContents)componentContents;
                    int idx = "misc.apotheosis.affix_name.four".equals(tContents.m_237508_()) ? 2 : 1;
                    tContents.m_237523_()[idx] = ci.getReturnValue();
                    ci.setReturnValue((Object)component);
                } else {
                    afxData.m_128473_("name");
                }
            }
            catch (Exception exception) {
                afxData.m_128473_("name");
            }
        }
    }

    @ModifyVariable(at=@At(value="INVOKE", target="net/minecraft/world/item/ItemStack.getDamageValue()I"), method={"hurt"}, argsOnly=true, ordinal=0)
    public int swapDura(int amount, int amountCopy, RandomSource pRandom, @Nullable ServerPlayer pUser) {
        int blocked = 0;
        DoubleStream chances = AffixHelper.getAffixes((ItemStack)this).values().stream().mapToDouble(inst -> inst.getDurabilityBonusPercentage(pUser));
        double chance = chances.reduce(0.0, (res, ele) -> res + (1.0 - res) * ele);
        int delta = 1;
        if (chance < 0.0) {
            delta = -1;
            chance = -chance;
        }
        if (chance > 0.0) {
            for (int i = 0; i < amount; ++i) {
                if (!((double)pRandom.m_188501_() <= chance)) continue;
                blocked += delta;
            }
        }
        return amount - blocked;
    }
}

