/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.potion;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.objects.GlowyBlockItem;
import dev.shadowsoffire.apotheosis.potion.PotionCharmItem;
import dev.shadowsoffire.apotheosis.potion.PotionCharmRecipe;
import dev.shadowsoffire.apotheosis.potion.PotionEnchantingRecipe;
import dev.shadowsoffire.apotheosis.potion.PotionModuleClient;
import dev.shadowsoffire.apotheosis.potion.compat.CuriosCompat;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.registry.RegistryEvent;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

public class PotionModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Potion");
    public static final ResourceLocation POTION_TEX = new ResourceLocation("apotheosis", "textures/potions.png");
    public static int knowledgeMult = 4;
    static boolean charmsInCuriosOnly = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        this.reload(null);
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().register(PotionModuleClient.class);
        }
        InterModComms.sendTo((String)"curios", (String)"REGISTER_TYPE", () -> new SlotTypeMessage.Builder("charm").size(1).build());
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42748_, (Potion)((Potion)Apoth.Potions.RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.RESISTANCE.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.RESISTANCE.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.RESISTANCE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.SUNDERING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.LONG_RESISTANCE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.LONG_SUNDERING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.STRONG_RESISTANCE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.STRONG_SUNDERING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.SUNDERING.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_SUNDERING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.SUNDERING.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_SUNDERING.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42436_, (Potion)((Potion)Apoth.Potions.ABSORPTION.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.ABSORPTION.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_ABSORPTION.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.ABSORPTION.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_ABSORPTION.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42400_, (Potion)((Potion)Apoth.Potions.HASTE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.HASTE.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_HASTE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.HASTE.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_HASTE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.HASTE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.FATIGUE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.LONG_HASTE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.LONG_FATIGUE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.STRONG_HASTE.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.STRONG_FATIGUE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.FATIGUE.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_FATIGUE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.FATIGUE.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_FATIGUE.get()));
            if (Apoth.Items.SKULL_FRAGMENT.isPresent()) {
                PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)Apoth.Items.SKULL_FRAGMENT.get()), (Potion)((Potion)Apoth.Potions.WITHER.get()));
            } else {
                PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42679_, (Potion)((Potion)Apoth.Potions.WITHER.get()));
            }
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.WITHER.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_WITHER.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.WITHER.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_WITHER.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42612_, (Potion)((Potion)Apoth.Potions.KNOWLEDGE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.KNOWLEDGE.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_KNOWLEDGE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.KNOWLEDGE.get()), (Item)Items.f_42612_, (Potion)((Potion)Apoth.Potions.STRONG_KNOWLEDGE.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)Apoth.Items.LUCKY_FOOT.get()), (Potion)Potions.f_43595_);
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42780_, (Potion)((Potion)Apoth.Potions.VITALITY.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.VITALITY.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_VITALITY.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.VITALITY.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_VITALITY.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.VITALITY.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.GRIEVOUS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.LONG_VITALITY.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.LONG_GRIEVOUS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.STRONG_VITALITY.get()), (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.STRONG_GRIEVOUS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.GRIEVOUS.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_GRIEVOUS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.GRIEVOUS.get()), (Item)Items.f_42525_, (Potion)((Potion)Apoth.Potions.STRONG_GRIEVOUS.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43596_, (Item)Items.f_42592_, (Potion)((Potion)Apoth.Potions.LEVITATION.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.LEVITATION.get()), (Item)Items.f_42731_, (Potion)((Potion)Apoth.Potions.FLYING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.FLYING.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.LONG_FLYING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)Apoth.Potions.LONG_FLYING.get()), (Item)Items.f_42451_, (Potion)((Potion)Apoth.Potions.EXTRA_LONG_FLYING.get()));
        });
        Apotheosis.HELPER.registerProvider(factory -> {
            Ingredient fireRes = Apotheosis.potionIngredient(Potions.f_43610_);
            Ingredient abs = Apotheosis.potionIngredient((Potion)Apoth.Potions.STRONG_ABSORPTION.get());
            Ingredient res = Apotheosis.potionIngredient((Potion)Apoth.Potions.RESISTANCE.get());
            Ingredient regen = Apotheosis.potionIngredient(Potions.f_43589_);
            factory.addShaped((Object)Items.f_42437_, 3, 3, new Object[]{fireRes, regen, fireRes, abs, Items.f_42436_, abs, res, abs, res});
        });
        MinecraftForge.EVENT_BUS.addListener(this::drops);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll(new Object[]{new GlowyBlockItem.GlowyItem(new Item.Properties()), "lucky_foot", new PotionCharmItem(), "potion_charm"});
        TabFillingRegistry.register((ResourceKey)CreativeModeTabs.f_256968_, (Supplier[])new Supplier[]{Apoth.Items.LUCKY_FOOT});
        TabFillingRegistry.register((ResourceKey)CreativeModeTabs.f_256869_, (Supplier[])new Supplier[]{Apoth.Items.POTION_CHARM});
    }

    @SubscribeEvent
    public void types(RegistryEvent.Register<Potion> e) {
        e.getRegistry().registerAll(new Object[]{new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 3600)}), "resistance", new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 9600)}), "long_resistance", new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 1800, 1)}), "strong_resistance", new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 1200, 1)}), "absorption", new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 3600, 1)}), "long_absorption", new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 600, 3)}), "strong_absorption", new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 3600)}), "haste", new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 9600)}), "long_haste", new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 1800, 1)}), "strong_haste", new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 3600)}), "fatigue", new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 9600)}), "long_fatigue", new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 1800, 1)}), "strong_fatigue", new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 3600)}), "wither", new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 9600)}), "long_wither", new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 1800, 1)}), "strong_wither", new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.SUNDERING.get(), 3600)}), "sundering", new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.SUNDERING.get(), 9600)}), "long_sundering", new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.SUNDERING.get(), 1800, 1)}), "strong_sundering", new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.KNOWLEDGE.get(), 2400)}), "knowledge", new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.KNOWLEDGE.get(), 4800)}), "long_knowledge", new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.KNOWLEDGE.get(), 1200, 1)}), "strong_knowledge", new Potion("vitality", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.VITALITY.get(), 4800)}), "vitality", new Potion("vitality", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.VITALITY.get(), 14400)}), "long_vitality", new Potion("vitality", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.VITALITY.get(), 3600, 1)}), "strong_vitality", new Potion("grievous", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.GRIEVOUS.get(), 4800)}), "grievous", new Potion("grievous", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.GRIEVOUS.get(), 14400)}), "long_grievous", new Potion("grievous", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.GRIEVOUS.get(), 3600, 1)}), "strong_grievous", new Potion("levitation", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19620_, 2400)}), "levitation", new Potion("flying", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.FLYING.get(), 9600)}), "flying", new Potion("flying", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.FLYING.get(), 18000)}), "long_flying", new Potion("flying", new MobEffectInstance[]{new MobEffectInstance((MobEffect)ALObjects.MobEffects.FLYING.get(), 36000)}), "extra_long_flying"});
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((Object)PotionCharmRecipe.Serializer.INSTANCE, Apoth.Items.POTION_CHARM.getId());
        e.getRegistry().register((Object)PotionEnchantingRecipe.SERIALIZER, "potion_charm_enchanting");
    }

    @SubscribeEvent
    public void imcEvent(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.sendIMC();
        }
    }

    public void drops(LivingDropsEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)livingEntity;
            if (rabbit.m_9236_().f_46441_.m_188501_() < 0.045f + 0.045f * (float)e.getLootingLevel()) {
                e.getDrops().clear();
                e.getDrops().add(new ItemEntity(rabbit.m_9236_(), rabbit.m_20185_(), rabbit.m_20186_(), rabbit.m_20189_(), new ItemStack((ItemLike)Apoth.Items.LUCKY_FOOT.get())));
            }
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "potion.cfg"));
        config.setTitle("Apotheosis Potion Module Configuration");
        knowledgeMult = config.getInt("Knowledge XP Multiplier", "general", knowledgeMult, 1, Integer.MAX_VALUE, "The strength of Ancient Knowledge.  This multiplier determines how much additional xp is granted.\nServer-authoritative.");
        charmsInCuriosOnly = config.getBoolean("Restrict Charms to Curios", "general", charmsInCuriosOnly, "If Potion Charms will only work when in a curios slot, instead of in the inventory.");
        String[] defExt = new String[]{ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19611_).toString(), ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19616_).toString()};
        String[] names = config.getStringList("Extended Potion Charms", "general", defExt, "A list of effects that, when as charms, will be applied and reapplied at a longer threshold to avoid issues at low durations, like night vision.\nServer-authoritative.");
        PotionCharmItem.EXTENDED_POTIONS.clear();
        for (String s : names) {
            try {
                PotionCharmItem.EXTENDED_POTIONS.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException ex) {
                LOG.error("Invalid extended potion charm entry {} will be ignored.", (Object)s);
            }
        }
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

