/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn.spawner;

import dev.shadowsoffire.apotheosis.spawn.spawner.LyingLevel;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class ApothSpawnerTile
extends SpawnerBlockEntity {
    public boolean ignoresPlayers = false;
    public boolean ignoresConditions = false;
    public boolean redstoneControl = false;
    public boolean ignoresLight = false;
    public boolean hasNoAI = false;
    public boolean silent = false;
    public boolean baby = false;

    public ApothSpawnerTile(BlockPos pos, BlockState state) {
        super(pos, state);
        this.f_59788_ = new SpawnerLogicExt();
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128379_("ignore_players", this.ignoresPlayers);
        tag.m_128379_("ignore_conditions", this.ignoresConditions);
        tag.m_128379_("redstone_control", this.redstoneControl);
        tag.m_128379_("ignore_light", this.ignoresLight);
        tag.m_128379_("no_ai", this.hasNoAI);
        tag.m_128379_("silent", this.silent);
        tag.m_128379_("baby", this.baby);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        this.ignoresPlayers = tag.m_128471_("ignore_players");
        this.ignoresConditions = tag.m_128471_("ignore_conditions");
        this.redstoneControl = tag.m_128471_("redstone_control");
        this.ignoresLight = tag.m_128471_("ignore_light");
        this.hasNoAI = tag.m_128471_("no_ai");
        this.silent = tag.m_128471_("silent");
        this.baby = tag.m_128471_("baby");
        super.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public class SpawnerLogicExt
    extends BaseSpawner {
        public void m_253197_(EntityType<?> type, @Nullable Level level, RandomSource rand, BlockPos pos) {
            this.f_45444_ = new SpawnData();
            super.m_253197_(type, level, rand, pos);
            this.f_45443_ = SimpleWeightedRandomList.m_185862_((Object)this.f_45444_);
            if (level != null) {
                this.m_151350_(level, pos);
            }
        }

        public void m_142523_(Level level, BlockPos pos, int id) {
            level.m_7696_(pos, Blocks.f_50085_, id, 0);
        }

        public void m_142667_(Level level, BlockPos pos, SpawnData nextSpawnData) {
            super.m_142667_(level, pos, nextSpawnData);
            if (level != null) {
                BlockState state = level.m_8055_(pos);
                level.m_7260_(pos, state, state, 4);
            }
        }

        @Nullable
        public BlockEntity getSpawnerBlockEntity() {
            return ApothSpawnerTile.this;
        }

        protected boolean isActivated(Level level, BlockPos pos) {
            boolean hasPlayer = ApothSpawnerTile.this.ignoresPlayers || this.m_151343_(level, pos);
            return hasPlayer && (!ApothSpawnerTile.this.redstoneControl || ApothSpawnerTile.this.f_58857_.m_276867_(pos));
        }

        private void m_151350_(Level pLevel, BlockPos pPos) {
            this.f_45442_ = this.f_45448_ <= this.f_45447_ ? this.f_45447_ : this.f_45447_ + pLevel.f_46441_.m_188503_(this.f_45448_ - this.f_45447_);
            this.f_45443_.m_216829_(pLevel.f_46441_).ifPresent(potential -> this.m_142667_(pLevel, pPos, (SpawnData)potential.m_146310_()));
            this.m_142523_(pLevel, pPos, 1);
        }

        public void m_151319_(Level pLevel, BlockPos pPos) {
            if (!this.isActivated(pLevel, pPos)) {
                this.f_45446_ = this.f_45445_;
            } else {
                double d0 = (double)pPos.m_123341_() + pLevel.f_46441_.m_188500_();
                double d1 = (double)pPos.m_123342_() + pLevel.f_46441_.m_188500_();
                double d2 = (double)pPos.m_123343_() + pLevel.f_46441_.m_188500_();
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
                if (this.f_45442_ > 0) {
                    --this.f_45442_;
                }
                this.f_45446_ = this.f_45445_;
                this.f_45445_ = (this.f_45445_ + (double)(1000.0f / ((float)this.f_45442_ + 200.0f))) % 360.0;
            }
        }

        public void m_151311_(ServerLevel level, BlockPos pPos) {
            if (this.isActivated((Level)level, pPos)) {
                if (this.f_45442_ == -1) {
                    this.m_151350_((Level)level, pPos);
                }
                if (this.f_45442_ > 0) {
                    --this.f_45442_;
                } else {
                    boolean flag = false;
                    RandomSource rand = level.m_213780_();
                    SpawnData spawnData = this.m_253144_((Level)level, rand, pPos);
                    for (int i = 0; i < this.f_45449_; ++i) {
                        int nearby;
                        Entity entity;
                        double z;
                        CompoundTag tag = spawnData.m_186567_();
                        EntityType entityType = EntityType.m_20637_((CompoundTag)tag).orElse(null);
                        if (entityType == null) {
                            this.m_151350_((Level)level, pPos);
                            return;
                        }
                        ListTag posList = tag.m_128437_("Pos", 6);
                        int size = posList.size();
                        double x = size >= 1 ? posList.m_128772_(0) : (double)pPos.m_123341_() + (rand.m_188500_() - rand.m_188500_()) * (double)this.f_45453_ + 0.5;
                        double y = size >= 2 ? posList.m_128772_(1) : (double)(pPos.m_123342_() + rand.m_188503_(3) - 1);
                        double d = z = size >= 3 ? posList.m_128772_(2) : (double)pPos.m_123343_() + (rand.m_188500_() - rand.m_188500_()) * (double)this.f_45453_ + 0.5;
                        if (!level.m_45772_(entityType.m_20585_(x, y, z))) continue;
                        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        LyingLevel liar = new LyingLevel(level);
                        boolean useLiar = false;
                        if (!ApothSpawnerTile.this.ignoresConditions) {
                            if (ApothSpawnerTile.this.ignoresLight) {
                                boolean pass = false;
                                for (int light = 0; light < 16; ++light) {
                                    liar.setFakeLightLevel(light);
                                    if (!this.checkSpawnRules(spawnData, entityType, (ServerLevelAccessor)liar, blockpos)) continue;
                                    pass = true;
                                    break;
                                }
                                if (!pass) continue;
                                useLiar = true;
                            } else if (!this.checkSpawnRules(spawnData, entityType, (ServerLevelAccessor)level, blockpos)) continue;
                        }
                        if ((entity = EntityType.m_20645_((CompoundTag)tag, (Level)level, freshEntity -> {
                            freshEntity.m_7678_(x, y, z, freshEntity.m_146908_(), freshEntity.m_146909_());
                            return freshEntity;
                        })) == null) {
                            this.m_151350_((Level)level, pPos);
                            return;
                        }
                        if (ApothSpawnerTile.this.hasNoAI) {
                            entity.m_20199_().filter(t -> t instanceof Mob).map(Mob.class::cast).forEach(mob -> {
                                mob.m_21557_(true);
                                mob.getPersistentData().m_128379_("apotheosis:movable", true);
                            });
                        }
                        if (ApothSpawnerTile.this.baby && entity instanceof Mob) {
                            Mob mob2 = (Mob)entity;
                            mob2.m_6863_(true);
                        }
                        if (ApothSpawnerTile.this.silent) {
                            entity.m_20225_(true);
                        }
                        if ((nearby = level.m_45976_(entity.getClass(), new AABB((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (double)(pPos.m_123341_() + 1), (double)(pPos.m_123342_() + 1), (double)(pPos.m_123343_() + 1)).m_82400_((double)this.f_45453_)).size()) >= this.f_45451_) {
                            this.m_151350_((Level)level, pPos);
                            return;
                        }
                        entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), rand.m_188501_() * 360.0f, 0.0f);
                        if (entity instanceof Mob) {
                            Mob mob3 = (Mob)entity;
                            if (!this.checkSpawnPositionSpawner(mob3, (ServerLevelAccessor)(useLiar ? liar : level), MobSpawnType.SPAWNER, spawnData, this)) continue;
                            MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob3, (ServerLevelAccessor)(useLiar ? liar : level), (DifficultyInstance)level.m_6436_(entity.m_20183_()), null, (CompoundTag)tag, (BaseSpawner)this);
                            if (event != null && spawnData.m_186567_().m_128440_() == 1 && spawnData.m_186567_().m_128425_("id", 8)) {
                                ((Mob)entity).m_6518_((ServerLevelAccessor)(useLiar ? liar : level), event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
                            }
                        }
                        if (!level.m_8860_(entity)) {
                            this.m_151350_((Level)level, pPos);
                            return;
                        }
                        level.m_46796_(2004, pPos, 0);
                        if (entity instanceof Mob) {
                            ((Mob)entity).m_21373_();
                        }
                        flag = true;
                    }
                    if (flag) {
                        this.m_151350_((Level)level, pPos);
                    }
                }
            }
        }

        public boolean checkSpawnPositionSpawner(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, SpawnData spawnData, BaseSpawner spawner) {
            MobSpawnEvent.PositionCheck event = new MobSpawnEvent.PositionCheck(mob, level, spawnType, null);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DEFAULT) {
                return ApothSpawnerTile.this.ignoresConditions || spawnData.m_186574_().isPresent() || mob.m_5545_((LevelAccessor)level, MobSpawnType.SPAWNER) && mob.m_6914_((LevelReader)level);
            }
            return event.getResult() == Event.Result.ALLOW;
        }

        private boolean checkSpawnRules(SpawnData spawnData, EntityType<?> entityType, ServerLevelAccessor pServerLevel, BlockPos blockpos) {
            if (spawnData.m_186574_().isPresent()) {
                if (!entityType.m_20674_().m_21609_() && pServerLevel.m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                SpawnData.CustomSpawnRules customRules = (SpawnData.CustomSpawnRules)spawnData.m_186574_().get();
                if (ApothSpawnerTile.this.ignoresLight) {
                    return true;
                }
                if (!customRules.f_186584_().m_184578_((Comparable)Integer.valueOf(pServerLevel.m_45517_(LightLayer.BLOCK, blockpos))) || !customRules.f_186585_().m_184578_((Comparable)Integer.valueOf(pServerLevel.m_45517_(LightLayer.SKY, blockpos)))) {
                    return false;
                }
            } else if (!SpawnPlacements.m_217074_(entityType, (ServerLevelAccessor)pServerLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)pServerLevel.m_213780_())) {
                return false;
            }
            return true;
        }
    }
}

