/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mixin.LivingEntityInvoker;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ExecutingAffix
extends Affix {
    public static final Codec<ExecutingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ExecutingAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public ExecutingAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ExecutingAffix.fmt(100.0f * this.getTrueLevel(rarity, level))}));
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        float threshold = this.getTrueLevel(rarity, level);
        if ((double)Apotheosis.getLocalAtkStrength((Entity)user) >= 0.98 && target instanceof LivingEntity) {
            DamageSource src;
            LivingEntity living = (LivingEntity)target;
            if (!living.m_9236_().f_46443_ && living.m_21223_() / living.m_21233_() < threshold && !((LivingEntityInvoker)living).callCheckTotemDeathProtection(src = living.m_269291_().m_269298_(Apoth.DamageTypes.EXECUTE, (Entity)user))) {
                SoundEvent soundevent = ((LivingEntityInvoker)living).callGetDeathSound();
                if (soundevent != null) {
                    living.m_5496_(soundevent, ((LivingEntityInvoker)living).callGetSoundVolume(), living.m_6100_());
                }
                living.m_6703_(user);
                if (user instanceof Player) {
                    Player p = (Player)user;
                    living.m_6598_(p);
                }
                living.m_21231_().m_289194_(src, 99999.0f);
                living.m_21153_(0.0f);
                living.m_6667_(src);
            }
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

