/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class FestiveAffix
extends Affix {
    public static Codec<FestiveAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, FestiveAffix::new));
    protected final Map<LootRarity, StepFunction> values;
    private static String MARKER = "apoth.equipment";

    public FestiveAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{FestiveAffix.fmt(100.0f * this.getTrueLevel(rarity, level))}));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isLightWeapon() && this.values.containsKey(rarity);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public void markEquipment(LivingDeathEvent e) {
        if (e.getEntity() instanceof Player || e.getEntity().getPersistentData().m_128471_("apoth.no_pinata")) {
            return;
        }
        e.getEntity().m_20158_().forEach(i -> {
            if (!i.m_41619_()) {
                i.m_41784_().m_128379_(MARKER, true);
            }
        });
    }

    public void drops(LivingDropsEvent e) {
        LivingEntity dead = e.getEntity();
        if (dead instanceof Player || dead.getPersistentData().m_128471_("apoth.no_pinata")) {
            return;
        }
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof Player) {
            AffixInstance inst;
            Player player = (Player)entity;
            if (!e.getDrops().isEmpty() && (inst = AffixHelper.getAffixes(player.m_21205_()).get(Apoth.Affixes.FESTIVE)) != null && inst.isValid() && player.m_9236_().f_46441_.m_188501_() < this.getTrueLevel((LootRarity)inst.rarity().get(), inst.level())) {
                player.m_9236_().m_6263_(null, dead.m_20185_(), dead.m_20186_(), dead.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123812_, dead.m_20185_(), dead.m_20186_(), dead.m_20189_(), 2, 1.0, 0.0, 0.0, 0.0);
                ArrayList drops = new ArrayList(e.getDrops());
                for (ItemEntity item : drops) {
                    if (item.m_32055_().m_41782_() && item.m_32055_().m_41783_().m_128441_(MARKER)) continue;
                    for (int i = 0; i < 20; ++i) {
                        e.getDrops().add(new ItemEntity(player.m_9236_(), item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_32055_().m_41777_()));
                    }
                }
                for (ItemEntity item : e.getDrops()) {
                    if (item.m_32055_().m_41720_().m_41465_()) continue;
                    item.m_6034_(dead.m_20185_(), dead.m_20186_(), dead.m_20189_());
                    item.m_20334_(-0.3 + dead.m_9236_().f_46441_.m_188500_() * 0.6, 0.3 + dead.m_9236_().f_46441_.m_188500_() * 0.3, -0.3 + dead.m_9236_().f_46441_.m_188500_() * 0.6);
                }
            }
        }
    }

    public void removeMarker(LivingDropsEvent e) {
        e.getDrops().stream().forEach(ent -> {
            ItemStack s = ent.m_32055_();
            if (s.m_41782_() && s.m_41783_().m_128441_(MARKER)) {
                s.m_41783_().m_128473_(MARKER);
                if (s.m_41783_().m_128456_()) {
                    s.m_41751_(null);
                }
            }
            ent.m_32045_(s);
        });
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

