/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionAffix
extends Affix {
    public static final Codec<PotionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(a -> a.cooldown), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply)).apply((Applicative)inst, PotionAffix::new));
    protected final MobEffect effect;
    protected final Target target;
    protected final Map<LootRarity, EffectData> values;
    @Deprecated(forRemoval=true, since="6.3.0")
    protected final int cooldown;
    protected final Set<LootCategory> types;
    protected final boolean stackOnReapply;

    public PotionAffix(MobEffect effect, Target target, Map<LootRarity, EffectData> values, int cooldown, Set<LootCategory> types, boolean stackOnReapply) {
        super(AffixType.ABILITY);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.cooldown = cooldown;
        this.types = types;
        this.stackOnReapply = stackOnReapply;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MobEffectInstance inst = this.values.get(rarity).build(this.effect, level);
        MutableComponent comp = this.target.toComponent(PotionAffix.toComponent(inst));
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)cooldown)});
            comp = comp.m_130946_(" ").m_7220_((Component)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"affix.apotheosis.stacking"));
        }
        list.accept((Component)comp);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return (this.types.isEmpty() || this.types.contains(cat)) && this.values.containsKey(rarity);
    }

    @Override
    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity attacker) {
        if (this.target == Target.HURT_SELF) {
            this.applyEffect(user, rarity, level);
        } else if (this.target == Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(tLiving, rarity, level);
        }
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if (this.target == Target.ATTACK_SELF) {
            this.applyEffect(user, rarity, level);
        } else if (this.target == Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(tLiving, rarity, level);
        }
    }

    @Override
    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((LivingEntity)player, rarity, level);
        }
    }

    @Override
    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, float level, HitResult res, HitResult.Type type) {
        Entity entity;
        if (this.target == Target.ARROW_SELF) {
            Entity entity2 = arrow.m_19749_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(owner, rarity, level);
            }
        } else if (this.target == Target.ARROW_TARGET && type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(target, rarity, level);
        }
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, rarity, level);
        } else if (this.target == Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(target, rarity, level);
        }
        return amount;
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        if (data.cooldown != -1) {
            return data.cooldown;
        }
        return this.cooldown;
    }

    private void applyEffect(LivingEntity target, LootRarity rarity, float level) {
        if (target.m_9236_().m_5776_()) {
            return;
        }
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && PotionAffix.isOnCooldown(this.getId(), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        MobEffectInstance inst = target.m_21124_(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                MobEffectInstance newInst = new MobEffectInstance(this.effect, (int)Math.max((float)inst.m_19557_(), data.duration.get(level)), (int)((float)(inst.m_19564_() + 1) + data.amplifier.get(level)));
                target.m_7292_(newInst);
            }
        } else {
            target.m_7292_(data.build(this.effect, level));
        }
        PotionAffix.startCooldown(this.getId(), target);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker");

        public static final Codec<Target> CODEC;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return Component.m_237110_((String)("affix.apotheosis.target." + this.id), (Object[])args);
        }

        static {
            CODEC = PlaceboCodecs.enumCodec(Target.class);
        }
    }

    public record EffectData(StepFunction duration, StepFunction amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(EffectData::duration), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)-1).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public MobEffectInstance build(MobEffect effect, float level) {
            return new MobEffectInstance(effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }
    }
}

