/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SpectralShotAffix
extends Affix {
    public static final Codec<SpectralShotAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, SpectralShotAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public SpectralShotAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isRanged() && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ItemStack.f_41584_.format(100.0f * this.getTrueLevel(rarity, level))}));
    }

    @Override
    public void onArrowFired(ItemStack stack, LootRarity rarity, float level, LivingEntity user, AbstractArrow arrow) {
        if (user.m_9236_().f_46441_.m_188501_() <= this.getTrueLevel(rarity, level) && !user.m_9236_().f_46443_) {
            ArrowItem arrowitem = (ArrowItem)Items.f_42737_;
            AbstractArrow spectralArrow = arrowitem.m_6394_(user.m_9236_(), ItemStack.f_41583_, user);
            spectralArrow.m_6686_((double)user.m_146909_(), (double)user.m_146908_(), 0.0, 2.0f, 1.0f);
            this.cloneMotion(arrow, spectralArrow);
            spectralArrow.m_36762_(arrow.m_36792_());
            spectralArrow.m_36781_(arrow.m_36789_());
            spectralArrow.m_36735_(arrow.f_36699_);
            spectralArrow.m_7311_(arrow.m_20094_());
            spectralArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            arrow.m_9236_().m_7967_((Entity)spectralArrow);
        }
    }

    private void cloneMotion(AbstractArrow src, AbstractArrow dest) {
        dest.m_20256_(src.m_20184_().m_82490_(1.0));
        dest.m_146922_(src.m_146908_());
        dest.m_146926_(src.m_146909_());
        dest.f_19859_ = dest.f_19859_;
        dest.f_19860_ = dest.f_19860_;
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

