/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket;

import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.event.ItemSocketingEvent;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SocketingRecipe
extends AdventureModule.ApothSmithingRecipe {
    private static final ResourceLocation ID = new ResourceLocation("apotheosis:socketing");

    public SocketingRecipe() {
        super(ID, Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Adventure.Items.GEM.get()}), ItemStack.f_41583_);
    }

    public boolean m_5818_(Container inv, Level pLevel) {
        ItemStack input = inv.m_8020_(1);
        ItemStack gemStack = inv.m_8020_(2);
        GemInstance gem = GemInstance.unsocketed(gemStack);
        if (!gem.isValidUnsocketed()) {
            return false;
        }
        if (!SocketHelper.hasEmptySockets(input)) {
            return false;
        }
        ItemSocketingEvent.CanSocket event = new ItemSocketingEvent.CanSocket(input, gemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Event.Result res = event.getResult();
        return res == Event.Result.ALLOW ? true : res == Event.Result.DEFAULT && gem.canApplyTo(input);
    }

    public ItemStack m_5874_(Container inv, RegistryAccess regs) {
        ItemStack input = inv.m_8020_(1);
        ItemStack gemStack = inv.m_8020_(2);
        if (input.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = input.m_41777_();
        result.m_41764_(1);
        int socket = SocketHelper.getFirstEmptySocket(result);
        ArrayList<ItemStack> gems = new ArrayList<ItemStack>(SocketHelper.getGems(result));
        ItemStack gemToInsert = gemStack.m_41777_();
        gemToInsert.m_41764_(1);
        gems.set(socket, gemStack.m_41777_());
        SocketHelper.setGems(result, gems);
        ItemSocketingEvent.ModifyResult event = new ItemSocketingEvent.ModifyResult(input, gemToInsert, result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        result = event.getOutput();
        if (result.m_41619_()) {
            throw new IllegalArgumentException("ItemSocketingEvent$ModifyResult produced an empty output stack.");
        }
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public ItemStack m_8043_(RegistryAccess regs) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50625_);
    }

    public ResourceLocation m_6423_() {
        return ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SocketingRecipe> {
        public static Serializer INSTANCE = new Serializer();

        public SocketingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            return new SocketingRecipe();
        }

        public SocketingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new SocketingRecipe();
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SocketingRecipe pRecipe) {
        }
    }
}

