/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;

public record GemInstance(DynamicHolder<Gem> gem, LootCategory cat, ItemStack gemStack, DynamicHolder<LootRarity> rarity) {
    public static GemInstance socketed(ItemStack socketed, ItemStack gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        DynamicHolder rarity = AffixHelper.getRarity(gemStack);
        if (gem.isBound() && rarity.isBound()) {
            rarity = RarityRegistry.INSTANCE.holder(((Gem)gem.get()).clamp((LootRarity)rarity.get()));
        }
        return new GemInstance(gem, LootCategory.forItem(socketed), gemStack, rarity);
    }

    public static GemInstance unsocketed(ItemStack gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        DynamicHolder rarity = AffixHelper.getRarity(gemStack);
        if (gem.isBound() && rarity.isBound()) {
            rarity = RarityRegistry.INSTANCE.holder(((Gem)gem.get()).clamp((LootRarity)rarity.get()));
        }
        return new GemInstance(gem, LootCategory.NONE, gemStack, rarity);
    }

    public boolean isValidUnsocketed() {
        return this.gem.isBound() && this.rarity.isBound();
    }

    public boolean isValid() {
        return this.isValidUnsocketed() && ((Gem)this.gem.get()).getBonus(this.cat).isPresent();
    }

    public boolean isMaxRarity() {
        return this.rarity().get() == ((Gem)this.gem.get()).getMaxRarity();
    }

    public boolean canApplyTo(ItemStack stack) {
        return ((Gem)this.gem.get()).canApplyTo(stack, this.gemStack, (LootRarity)this.rarity.get());
    }

    public void addModifiers(EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> map) {
        for (EquipmentSlot itemSlot : this.cat.getSlots()) {
            if (itemSlot != slot) continue;
            this.ifPresent(b -> b.addModifiers(this.gemStack, (LootRarity)this.rarity.get(), map));
        }
    }

    public Component getSocketBonusTooltip() {
        return this.map(b -> b.getSocketBonusTooltip(this.gemStack, (LootRarity)this.rarity.get())).orElse((Component)Component.m_237113_((String)"Invalid Gem Category"));
    }

    public int getDamageProtection(DamageSource source) {
        return this.map(b -> b.getDamageProtection(this.gemStack, (LootRarity)this.rarity.get(), source)).orElse(0);
    }

    public float getDamageBonus(MobType creatureType) {
        return this.map(b -> Float.valueOf(b.getDamageBonus(this.gemStack, (LootRarity)this.rarity.get(), creatureType))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void doPostAttack(LivingEntity user, @Nullable Entity target) {
        this.ifPresent(b -> b.doPostAttack(this.gemStack, (LootRarity)this.rarity.get(), user, target));
    }

    public void doPostHurt(LivingEntity user, @Nullable Entity attacker) {
        this.ifPresent(b -> b.doPostHurt(this.gemStack, (LootRarity)this.rarity.get(), user, attacker));
    }

    public void onArrowFired(LivingEntity user, AbstractArrow arrow) {
        this.ifPresent(b -> b.onArrowFired(this.gemStack, (LootRarity)this.rarity.get(), user, arrow));
    }

    @Nullable
    public InteractionResult onItemUse(UseOnContext ctx) {
        return this.map(b -> b.onItemUse(this.gemStack, (LootRarity)this.rarity.get(), ctx)).orElse(null);
    }

    public void onArrowImpact(AbstractArrow arrow, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(LivingEntity entity, DamageSource source, float amount) {
        return this.map(b -> Float.valueOf(b.onShieldBlock(this.gemStack, (LootRarity)this.rarity.get(), entity, source, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void onBlockBreak(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        this.ifPresent(b -> b.onBlockBreak(this.gemStack, (LootRarity)this.rarity.get(), player, world, pos, state));
    }

    public float getDurabilityBonusPercentage(ServerPlayer user) {
        return this.map(b -> Float.valueOf(b.getDurabilityBonusPercentage(this.gemStack, (LootRarity)this.rarity.get(), user))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float onHurt(DamageSource src, LivingEntity ent, float amount) {
        return this.map(b -> Float.valueOf(b.onHurt(this.gemStack, (LootRarity)this.rarity.get(), src, ent, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void getEnchantmentLevels(Map<Enchantment, Integer> enchantments) {
        this.ifPresent(b -> b.getEnchantmentLevels(this.gemStack, (LootRarity)this.rarity.get(), enchantments));
    }

    public void modifyLoot(ObjectArrayList<ItemStack> loot, LootContext ctx) {
        this.ifPresent(b -> b.modifyLoot(this.gemStack, (LootRarity)this.rarity.get(), loot, ctx));
    }

    private <T> Optional<T> map(Function<GemBonus, T> function) {
        return ((Gem)this.gem.get()).getBonus(this.cat).map(function);
    }

    private void ifPresent(Consumer<GemBonus> function) {
        ((Gem)this.gem.get()).getBonus(this.cat).ifPresent(function);
    }
}

